/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.property;

import java.util.ArrayList;
import java.util.HashMap;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.utils.CastorArrayList;

public class PropertyDescriptionList
extends CastorArrayList<PropertyDescription> {
    public PropertyDescriptionList() {
    }

    public PropertyDescriptionList(ArrayList<PropertyDescription> aList) {
        super(aList);
    }

    public String getClassProps() {
        StringBuffer props = new StringBuffer();
        for (PropertyDescription element : this.list) {
            if (!element.getIsClassIdentifier()) continue;
            if (props.length() > 0) {
                props.append(",");
            }
            props.append(element.getName());
        }
        return props.toString();
    }

    public boolean setDefaultValue(String name, String value) {
        for (PropertyDescription element : this.list) {
            if (!element.getName().equals(name)) continue;
            element.setDefaultValue(value);
            return true;
        }
        return false;
    }

    public void add(String name, String value, boolean isClassId, boolean isMutable, boolean isTransitive) {
        for (PropertyDescription element : this.list) {
            if (!element.getName().equals(name)) continue;
            this.list.remove(element);
            break;
        }
        this.list.add(new PropertyDescription(name, value, isClassId, isMutable, isTransitive));
    }

    public void add(String name, String value, boolean isClassId, boolean isMutable) {
        this.add(name, value, isClassId, isMutable, false);
    }

    public boolean definesProperty(String name) {
        for (PropertyDescription element : this.list) {
            if (!element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public PropertyArrayList instantiate(PropertyArrayList initProps) throws InvalidDataException {
        HashMap<String, String> validatedInitProps = new HashMap<String, String>();
        for (Property initProp : initProps.list) {
            if (!this.definesProperty(initProp.getName())) {
                throw new InvalidDataException("Property " + initProp.getName() + " has not been declared in the property descriptions");
            }
            validatedInitProps.put(initProp.getName(), initProp.getValue());
        }
        PropertyArrayList propInst = new PropertyArrayList();
        for (int i = 0; i < this.list.size(); ++i) {
            PropertyDescription pd = (PropertyDescription)this.list.get(i);
            String propName = pd.getName();
            String propVal = pd.getDefaultValue();
            if (validatedInitProps.containsKey(propName)) {
                propVal = (String)validatedInitProps.get(propName);
            }
            propInst.list.add(new Property(propName, propVal, pd.getIsMutable()));
        }
        return propInst;
    }
}

