/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.utils.Logger;

public class ImportRole
extends ModuleImport {
    public Boolean jobList;
    public ArrayList<String> permissions = new ArrayList();

    @Override
    public Path create(AgentPath agentPath, boolean reset) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        RolePath newRolePath = new RolePath(this.name.split("/"), this.jobList == null ? false : this.jobList, this.permissions);
        if (Gateway.getLookup().exists(newRolePath)) {
            if (this.jobList != null) {
                this.update(agentPath);
            }
        } else {
            Logger.msg("ImportRole.create() - Creating Role:" + this.name + " joblist:" + this.jobList, new Object[0]);
            newRolePath.getParent();
            Gateway.getLookupManager().createRole(newRolePath);
            Gateway.getLookupManager().setPermissions(newRolePath, newRolePath.getPermissions());
        }
        return newRolePath;
    }

    public void update(AgentPath agentPath) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        RolePath rolePath = new RolePath(this.name.split("/"), this.jobList == null ? false : this.jobList, this.permissions);
        if (!Gateway.getLookup().exists(rolePath)) {
            throw new ObjectNotFoundException("Role '" + rolePath.getName() + "' does NOT exists.");
        }
        Gateway.getLookupManager().setHasJobList(rolePath, this.jobList == null ? false : this.jobList);
        Gateway.getLookupManager().setPermissions(rolePath, this.permissions);
    }

    public static ImportRole getImportRole(RolePath rp) {
        ImportRole ir = new ImportRole();
        ir.setName(rp.getName());
        ir.jobList = rp.hasJobList();
        ir.permissions = (ArrayList)rp.getPermissions();
        return ir;
    }
}

