/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.WfCastorHashMap;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.JobPusher;
import org.cristalise.kernel.lifecycle.instance.Join;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.predefined.WriteProperty;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.OutcomeAttachment;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Activity
extends WfVertex {
    protected static final String XPATH_TOKEN = "xpath:";
    protected Vector<String> mErrors;
    private StateMachine machine;
    protected int state = -1;
    public boolean active = false;
    private boolean loopTested;
    private GTimeStamp mStateDate;
    private String mType;
    private String mTypeName;

    public Activity() {
        this.setProperties(new WfCastorHashMap());
        this.mErrors = new Vector(0, 1);
        this.mStateDate = new GTimeStamp();
        DateUtility.setToNow(this.mStateDate);
    }

    Next addNext(String idNext) {
        return this.addNext((WfVertex)this.getParent().search(idNext));
    }

    @Override
    public Next addNext(WfVertex vertex) {
        return new Next(this, vertex);
    }

    public StateMachine getStateMachine() throws InvalidDataException {
        if (this.machine == null) {
            try {
                this.machine = LocalObjectLoader.getStateMachine(this.getProperties());
            }
            catch (ObjectNotFoundException e) {
                throw new InvalidDataException(e.getMessage());
            }
        }
        return this.machine;
    }

    public int getState() throws InvalidDataException {
        if (this.state == -1) {
            this.state = this.getStateMachine().getInitialStateCode();
        }
        return this.state;
    }

    public int getErrorTransitionId() {
        try {
            return this.getStateMachine().getErrorTransitionIdForState(this.getState());
        }
        catch (InvalidDataException e) {
            return -1;
        }
    }

    public String getStateName() throws InvalidDataException {
        return this.getStateMachine().getState(this.getState()).getName();
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isFinished() throws InvalidDataException {
        return this.getStateMachine().getState(this.getState()).isFinished();
    }

    public String request(AgentPath agent, AgentPath delegate, ItemPath itemPath, int transitionID, String requestData, String attachmentType, byte[] attachment, Object locker) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        Transition transition = this.getStateMachine().getTransition(transitionID);
        String usedRole = transition.getPerformingRole(this, agent);
        boolean storeOutcome = false;
        if (transition.hasOutcome(this.getProperties())) {
            if (StringUtils.isNotBlank((CharSequence)requestData)) {
                storeOutcome = true;
            } else if (transition.getOutcome().isRequired()) {
                throw new InvalidDataException("Transition requires outcome data, but none was given");
            }
        }
        State oldState = this.getStateMachine().getState(this.state);
        State newState = this.getStateMachine().traverse(this, transition, agent);
        String outcome = this.runActivityLogic(agent, itemPath, transitionID, requestData, locker);
        this.setState(newState.getId());
        this.setBuiltInProperty(BuiltInVertexProperties.AGENT_NAME, transition.getReservation(this, agent));
        try {
            History hist = this.getWf().getHistory(locker);
            if (storeOutcome) {
                Schema schema = transition.getSchema(this.getProperties());
                Outcome newOutcome = new Outcome(-1, outcome, schema);
                String viewpoint = this.resolveViewpointName(newOutcome);
                int eventID = hist.addEvent(agent, delegate, usedRole, this.getName(), this.getPath(), this.getType(), schema, this.getStateMachine(), transitionID, viewpoint).getID();
                newOutcome.setID(eventID);
                Gateway.getStorage().put(itemPath, newOutcome, locker);
                if (attachment.length > 0) {
                    Gateway.getStorage().put(itemPath, new OutcomeAttachment(itemPath, newOutcome, attachmentType, attachment), locker);
                }
                if (!viewpoint.equals("last")) {
                    Gateway.getStorage().put(itemPath, new Viewpoint(itemPath, schema, viewpoint, eventID), locker);
                }
                Gateway.getStorage().put(itemPath, new Viewpoint(itemPath, schema, "last", eventID), locker);
                this.updateItemProperties(itemPath, newOutcome, locker);
            } else {
                this.updateItemProperties(itemPath, null, locker);
                hist.addEvent(agent, delegate, usedRole, this.getName(), this.getPath(), this.getType(), this.getStateMachine(), transitionID);
            }
        }
        catch (PersistencyException ex) {
            Logger.error((Throwable)((Object)ex));
            throw ex;
        }
        if (newState.isFinished() && (!this.getBuiltInProperty(BuiltInVertexProperties.BREAKPOINT).equals(Boolean.TRUE) || oldState.isFinished())) {
            this.runNext(agent, itemPath, locker);
        }
        DateUtility.setToNow(this.mStateDate);
        this.pushJobsToAgents(itemPath);
        return outcome;
    }

    private String resolveViewpointName(Outcome outcome) throws InvalidDataException {
        String viewpointString = (String)this.getBuiltInProperty(BuiltInVertexProperties.VIEW_POINT);
        Logger.msg(5, "Activity.resolveViewpointName() - act:%s viewpointString:%s", this.getName(), viewpointString);
        if (StringUtils.isBlank((CharSequence)viewpointString)) {
            viewpointString = "last";
        } else if (viewpointString.startsWith(XPATH_TOKEN)) {
            try {
                viewpointString = outcome.getFieldByXPath(viewpointString.substring(XPATH_TOKEN.length()));
            }
            catch (XPathExpressionException e) {
                throw new InvalidDataException(e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)viewpointString)) {
            throw new InvalidDataException("Resolved viewpoint name cannot be blank for activity:" + this.getName());
        }
        return viewpointString;
    }

    private void updateItemProperties(ItemPath itemPath, Outcome outcome, Object locker) throws InvalidDataException, PersistencyException, ObjectCannotBeUpdated, ObjectNotFoundException {
        for (Map.Entry entry : this.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("ItemProperty.")) continue;
            String propName = ((String)entry.getKey()).substring(13);
            if (StringUtils.isNotBlank((CharSequence)propName)) {
                String propValue = entry.getValue().toString();
                if (outcome != null && StringUtils.isNotBlank((CharSequence)propValue) && propValue.startsWith(XPATH_TOKEN)) {
                    try {
                        propValue = outcome.getFieldByXPath(propValue.substring(XPATH_TOKEN.length()));
                    }
                    catch (XPathExpressionException e) {
                        throw new InvalidDataException(e.getMessage());
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)propValue)) continue;
                Logger.msg(5, "Activity.updateItemProperties() - propName:" + propName + " propValue:" + propValue, new Object[0]);
                WriteProperty.write(itemPath, propName, propValue, locker);
                continue;
            }
            throw new InvalidDataException("Incomplete vertex property name:" + (String)entry.getKey());
        }
    }

    protected String runActivityLogic(AgentPath agent, ItemPath itemPath, int transitionID, String requestData, Object locker) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException, AccessRightsException {
        return requestData;
    }

    @Override
    public boolean verify() {
        this.mErrors.removeAllElements();
        int nbInEdgres = this.getInEdges().length;
        int nbOutEdges = this.getOutEdges().length;
        if (nbInEdgres == 0 && this.getID() != this.getParent().getChildrenGraphModel().getStartVertexId()) {
            this.mErrors.add("Unreachable");
            return false;
        }
        if (nbInEdgres > 1) {
            this.mErrors.add("Bad nb of previous");
            return false;
        }
        if (nbOutEdges > 1) {
            this.mErrors.add("too many next");
            return false;
        }
        if (nbOutEdges == 0 && !((CompositeActivity)this.getParent()).hasGoodNumberOfActivity()) {
            this.mErrors.add("too many endpoints");
            return false;
        }
        return true;
    }

    @Override
    public boolean loop() {
        boolean loop2 = false;
        if (!this.loopTested) {
            this.loopTested = true;
            if (this.getOutGraphables().length != 0) {
                loop2 = ((WfVertex)this.getOutGraphables()[0]).loop();
            }
        }
        this.loopTested = false;
        return loop2;
    }

    @Override
    public void runNext(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        this.setActive(false);
        try {
            Object[] outVertices = this.getOutGraphables();
            Object[] outVertices2 = this.getOutGraphables();
            boolean hasNoNext = false;
            boolean out = false;
            while (!out) {
                if (outVertices2.length > 0) {
                    if (outVertices2[0] instanceof Join) {
                        outVertices2 = ((WfVertex)outVertices2[0]).getOutGraphables();
                        continue;
                    }
                    out = true;
                    continue;
                }
                hasNoNext = true;
                out = true;
            }
            if (Logger.doLog(8)) {
                Logger.msg("Activity.next(parent:" + this.getParent().getName() + ") - " + Arrays.toString(outVertices) + " " + Arrays.toString(outVertices2), new Object[0]);
            }
            if (hasNoNext) {
                if (this.getParent() != null && this.getParent().getName().equals("domain")) {
                    this.setActive(true);
                } else {
                    CompositeActivity parent = (CompositeActivity)this.getParent();
                    if (parent != null) {
                        parent.runNext(agent, itemPath, locker);
                    }
                }
            } else {
                ((WfVertex)outVertices[0]).run(agent, itemPath, locker);
            }
        }
        catch (InvalidDataException s) {
            this.setActive(true);
            throw s;
        }
    }

    public Next getNext() {
        if (this.getOutEdges().length > 0) {
            return (Next)this.getOutEdges()[0];
        }
        return null;
    }

    @Override
    public void reinit(int idLoop) throws InvalidDataException {
        Vertex[] outVertices = this.getOutGraphables();
        this.setState(this.getStateMachine().getInitialState().getId());
        if (outVertices.length > 0 && idLoop != this.getID()) {
            WfVertex nextAct = (WfVertex)outVertices[0];
            nextAct.reinit(idLoop);
        }
    }

    @Override
    public String getErrors() {
        if (this.mErrors.size() == 0) {
            return "No error";
        }
        return this.mErrors.elementAt(0);
    }

    @Override
    public void run(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        boolean finished;
        Logger.msg(8, "Activity.run() path:" + this.getPath() + " state:" + this.getState(), new Object[0]);
        if (!this.getActive()) {
            this.setActive(true);
        }
        if (finished = this.getStateMachine().getState(this.getState()).isFinished()) {
            this.runNext(agent, itemPath, locker);
        } else {
            DateUtility.setToNow(this.mStateDate);
            this.pushJobsToAgents(itemPath);
        }
    }

    @Override
    public void runFirst(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        Logger.msg(8, "Activity.runFirst() - path:" + this.getPath(), new Object[0]);
        this.run(agent, itemPath, locker);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean acti) {
        this.active = acti;
    }

    public String getDescription() {
        if (this.getProperties().containsKey("Description")) {
            return (String)this.getBuiltInProperty(BuiltInVertexProperties.DESCRIPTION);
        }
        return "No description";
    }

    public String getCurrentAgentName() {
        return (String)this.getBuiltInProperty(BuiltInVertexProperties.AGENT_NAME);
    }

    public String getCurrentAgentRole() {
        return (String)this.getBuiltInProperty(BuiltInVertexProperties.AGENT_ROLE);
    }

    public ArrayList<Job> calculateJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws InvalidAgentPathException, ObjectNotFoundException, InvalidDataException {
        return this.calculateJobsBase(agent, itemPath, false);
    }

    public ArrayList<Job> calculateAllJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws InvalidAgentPathException, ObjectNotFoundException, InvalidDataException {
        return this.calculateJobsBase(agent, itemPath, true);
    }

    private ArrayList<Job> calculateJobsBase(AgentPath agent, ItemPath itemPath, boolean includeInactive) throws ObjectNotFoundException, InvalidDataException, InvalidAgentPathException {
        Logger.msg(7, "Activity.calculateJobsBase() - act:" + this.getPath(), new Object[0]);
        ArrayList<Job> jobs = new ArrayList<Job>();
        if ((includeInactive || this.getActive()) && !this.getName().equals("domain")) {
            Map<Transition, String> transitions = this.getStateMachine().getPossibleTransitions(this, agent);
            Logger.msg(7, "Activity.calculateJobsBase() - Got " + transitions.size() + " transitions.", new Object[0]);
            for (Transition transition : transitions.keySet()) {
                Logger.msg(7, "Activity.calculateJobsBase() - Creating Job object for transition " + transition.getName(), new Object[0]);
                jobs.add(new Job(this, itemPath, transition, agent, null, transitions.get(transition)));
            }
        }
        return jobs;
    }

    protected void pushJobsToAgents(ItemPath itemPath) {
        TreeSet<Object> roleNames = new TreeSet<Object>();
        String role = this.getCurrentAgentRole();
        if (StringUtils.isNotBlank((CharSequence)role)) {
            for (String r : role.split(",")) {
                roleNames.add(r);
            }
        }
        try {
            for (Transition transition : this.getStateMachine().getState(this.getState()).getPossibleTransitions().values()) {
                role = transition.getRoleOverride(this.getProperties());
                if (!StringUtils.isNotBlank((CharSequence)role)) continue;
                roleNames.add(role);
            }
            Logger.msg(7, "Activity.pushJobsToAgents() - Pushing jobs to " + roleNames.size() + " roles", new Object[0]);
            for (String string : roleNames) {
                this.pushJobsToAgents(itemPath, Gateway.getLookup().getRolePath(string));
            }
        }
        catch (InvalidDataException ex) {
            Logger.warning("Activity.pushJobsToAgents() - " + ex.getMessage(), new Object[0]);
        }
        catch (ObjectNotFoundException e) {
            Logger.warning("Activity.pushJobsToAgents() - Activity role '" + role + "' not found.", new Object[0]);
        }
    }

    protected void pushJobsToAgents(ItemPath itemPath, RolePath role) {
        if (role.hasJobList()) {
            new JobPusher(this, itemPath, role).start();
        }
        Iterator<Path> childRoles = role.getChildren();
        while (childRoles.hasNext()) {
            this.pushJobsToAgents(itemPath, (RolePath)childRoles.next());
        }
    }

    public GTimeStamp getStateDate() {
        return this.mStateDate;
    }

    public void setStateDate(GTimeStamp startDate) {
        this.mStateDate = startDate;
    }

    @Deprecated
    public void setActiveDate(GTimeStamp date) {
    }

    @Deprecated
    public void setStartDate(GTimeStamp date) {
        this.setStateDate(date);
    }

    public String getType() {
        return this.mType;
    }

    public String getTypeName() {
        if (this.mType == null) {
            return null;
        }
        if (this.mTypeName == null) {
            try {
                ItemPath actType = new ItemPath(this.mType);
                Property nameProp = (Property)Gateway.getStorage().get(actType, (Object)((Object)ClusterType.PROPERTY) + "/" + (Object)((Object)BuiltInItemProperties.NAME), null);
                this.mTypeName = nameProp.getValue();
            }
            catch (Exception e) {
                this.mTypeName = this.mType;
            }
        }
        return this.mTypeName;
    }

    public void setType(String type) {
        this.mType = type;
        this.mTypeName = null;
    }

    @Override
    public void abort() {
        this.active = false;
    }
}

