/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepCollectionBase;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;

public class RemoveSlotFromCollection
extends PredefinedStepCollectionBase {
    public static final String description = "Removes the given slot from the collection";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, PersistencyException, InvalidCollectionModification {
        this.unpackParamsAndGetCollection(item, requestData, locker);
        if (this.collection instanceof Dependency && ((Dependency)this.collection).containsBuiltInProperty(BuiltInVertexProperties.MEMBER_REMOVE_SCRIPT)) {
            CastorHashMap scriptProps = new CastorHashMap();
            scriptProps.put("collection", this.collection);
            scriptProps.put("slotID", this.slotID);
            this.evaluateScript(item, (String)((Dependency)this.collection).getBuiltInProperty(BuiltInVertexProperties.MEMBER_REMOVE_SCRIPT), scriptProps, locker);
        }
        this.collection.removeMember(this.slotID);
        Gateway.getStorage().put(item, this.collection, locker);
        return requestData;
    }
}

