/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;

public class RolePath
extends Path {
    private boolean hasJobList = false;
    private List<String> permissions = new ArrayList<String>();

    public RolePath() {
    }

    public RolePath(String path) {
        super(path);
    }

    public RolePath(RolePath parent, String roleName) {
        super(parent, roleName);
    }

    public RolePath(RolePath parent, String roleName, List<String> permissions) {
        super(parent, roleName);
        this.permissions = permissions;
    }

    public RolePath(String path, boolean jobList) {
        super(path);
        this.hasJobList = jobList;
    }

    public RolePath(String path, boolean jobList, List<String> permissions) {
        super(path);
        this.hasJobList = jobList;
        this.permissions = permissions;
    }

    public RolePath(String[] path, boolean jobList) {
        super(path);
        this.hasJobList = jobList;
    }

    public RolePath(String[] path, boolean jobList, List<String> permissions) {
        super(path);
        this.hasJobList = jobList;
        this.permissions = permissions;
    }

    public RolePath(RolePath parent, String roleName, boolean jobList) {
        this(parent, roleName);
        this.hasJobList = jobList;
    }

    public RolePath(RolePath parent, String roleName, boolean jobList, List<String> permissions) {
        this(parent, roleName);
        this.hasJobList = jobList;
        this.permissions = permissions;
    }

    public RolePath getParent() throws ObjectNotFoundException {
        if (this.mPath.length < 2) {
            return null;
        }
        return Gateway.getLookup().getRolePath(this.mPath[this.mPath.length - 2]);
    }

    public boolean hasJobList() {
        return this.hasJobList;
    }

    public void setHasJobList(boolean hasJobList) {
        this.hasJobList = hasJobList;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public Iterator<Path> getChildren() {
        return Gateway.getLookup().getChildren(this);
    }

    @Override
    public String dump() {
        StringBuffer comp = new StringBuffer("Components: { ");
        for (String element : this.mPath) {
            comp.append("'").append(element).append("' ");
        }
        return "Path - dump(): " + comp.toString() + "}\n        string=" + this.toString() + "\n        name=" + this.getName() + "\n        ";
    }

    @Override
    public String getRoot() {
        return "role";
    }

    @Override
    public String getName() {
        if (this.mPath.length > 0) {
            return this.mPath[this.mPath.length - 1];
        }
        return this.getRoot();
    }

    @Override
    public String getClusterPath() {
        return (Object)((Object)ClusterType.PATH) + "/Role/" + StringUtils.join((Object[])this.mPath, (String)"");
    }
}

