/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.Map;
import java.util.StringTokenizer;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class DependencyMember
implements CollectionMember {
    private ItemPath mItemPath = null;
    private ItemProxy mItem = null;
    private int mId = -1;
    private CastorHashMap mProperties = new CastorHashMap();
    private String mClassProps = "";

    @Override
    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    @Override
    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    @Override
    public int getID() {
        return this.mId;
    }

    public void setID(int id) {
        this.mId = id;
    }

    public void setClassProps(String props) {
        this.mClassProps = props;
    }

    @Override
    public String getClassProps() {
        return this.mClassProps;
    }

    @Override
    public void assignItem(ItemPath itemPath) throws InvalidCollectionModification {
        if (itemPath != null) {
            if (this.mClassProps == null || this.getProperties() == null) {
                throw new InvalidCollectionModification("ClassProps not yet set. Cannot check membership validity.");
            }
            StringTokenizer sub = new StringTokenizer(this.mClassProps, ",");
            while (sub.hasMoreTokens()) {
                String aClassProp = sub.nextToken();
                try {
                    String memberValue = (String)this.getProperties().get(aClassProp);
                    Property itemProperty = (Property)Gateway.getStorage().get(itemPath, (Object)((Object)ClusterType.PROPERTY) + "/" + aClassProp, null);
                    if (itemProperty == null) {
                        throw new InvalidCollectionModification("Property " + aClassProp + " does not exist for item " + itemPath);
                    }
                    if (itemProperty.getValue().equalsIgnoreCase(memberValue)) continue;
                    throw new InvalidCollectionModification("DependencyMember::checkProperty() Values of mandatory prop " + aClassProp + " do not match " + itemProperty.getValue() + "!=" + memberValue);
                }
                catch (Exception ex) {
                    Logger.error(ex);
                    throw new InvalidCollectionModification("Error checking properties");
                }
            }
        }
        this.mItemPath = itemPath;
        this.mItem = null;
    }

    @Override
    public void clearItem() {
        this.mItemPath = null;
        this.mItem = null;
    }

    @Override
    public ItemProxy resolveItem() throws ObjectNotFoundException {
        if (this.mItem == null && this.mItemPath != null) {
            this.mItem = Gateway.getProxyManager().getProxy(this.mItemPath);
        }
        return this.mItem;
    }

    public void setChildUUID(String uuid) throws InvalidCollectionModification, InvalidItemPathException {
        this.mItemPath = new ItemPath(uuid);
    }

    @Override
    public String getChildUUID() {
        return this.mItemPath.getUUID().toString();
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop) {
        return this.mProperties.get(prop.getName());
    }

    public void setBuiltInProperty(BuiltInVertexProperties prop, Object val) {
        this.mProperties.put(prop.getName(), val);
    }

    protected Object evaluateScript() throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(5, "DependencyMember.evaluateScript() - memberUUID:" + this.getChildUUID(), new Object[0]);
        Script script = LocalObjectLoader.getScript(this.getProperties());
        try {
            script.setInputParamValue("dependencyMember", this);
            script.setInputParamValue("storage", Gateway.getStorage());
            script.setInputParamValue("proxy", Gateway.getProxyManager());
            script.setInputParamValue("lookup", Gateway.getLookup());
            return script.evaluate(this.getItemPath(), this.getProperties(), null, null);
        }
        catch (ScriptingEngineException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public void updateProperties(CastorHashMap newProps) throws ObjectNotFoundException, InvalidCollectionModification {
        for (Map.Entry newProp : newProps.entrySet()) {
            if (this.mClassProps.contains((CharSequence)newProp.getKey())) {
                throw new InvalidCollectionModification("Dependency cannot change classProperties:" + this.mClassProps);
            }
            if (this.getProperties().containsKey(newProp.getKey())) {
                this.getProperties().put(newProp.getKey(), newProp.getValue());
                continue;
            }
            throw new ObjectNotFoundException("Property " + (String)newProp.getKey() + " does not exists for slotID:" + this.getID());
        }
    }
}

