/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.Agent;
import org.cristalise.kernel.entity.AgentHelper;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.Parameter;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptErrorException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.CorbaExceptionUtility;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;

public class AgentProxy
extends ItemProxy {
    AgentPath mAgentPath;
    String mAgentName;

    protected AgentProxy(Object ior, AgentPath agentPath) throws ObjectNotFoundException {
        super(ior, agentPath);
        this.mAgentPath = agentPath;
    }

    @Override
    public Agent narrow() throws ObjectNotFoundException {
        try {
            return AgentHelper.narrow(this.mIOR);
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw new ObjectNotFoundException("CORBA Object was not an Agent, or the server is down.");
        }
    }

    public String execute(Job job, Job errorJob) throws ObjectNotFoundException, AccessRightsException, InvalidTransitionException, InvalidDataException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification, ScriptErrorException {
        if (errorJob == null) {
            throw new InvalidDataException("errorJob cannot be null");
        }
        try {
            return this.execute(job);
        }
        catch (Exception ex) {
            Logger.error(ex);
            try {
                errorJob.setAgentPath(this.mAgentPath);
                errorJob.setOutcome(Gateway.getMarshaller().marshall(new ErrorInfo(job, ex)));
                return this.execute(errorJob);
            }
            catch (IOException | MappingException | MarshalException | ValidationException e) {
                Logger.error(e);
                throw new InvalidDataException(e.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public String execute(Job job) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ScriptErrorException, InvalidCollectionModification {
        item = Gateway.getProxyManager().getProxy(job.getItemPath());
        startTime = new Date();
        Logger.msg(3, "AgentProxy.execute(job) - act:" + job.getStepPath() + " agent:" + this.mAgentPath.getAgentName(), new java.lang.Object[0]);
        if (job.hasScript()) {
            Logger.msg(3, "AgentProxy.execute(job) - executing script", new java.lang.Object[0]);
            try {
                scriptErrors = this.callScript(item, job);
                errorString = scriptErrors.toString();
                if (scriptErrors.getFatal()) {
                    Logger.error("AgentProxy.execute(job) - fatal script errors:" + scriptErrors, new java.lang.Object[0]);
                    throw new ScriptErrorException(scriptErrors);
                }
                if (errorString.length() <= 0) ** GOTO lbl26
                Logger.warning("Script errors: " + errorString, new java.lang.Object[0]);
            }
            catch (ScriptingEngineException ex) {
                cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                } else {
                    Logger.error(ex.getMessage(), new java.lang.Object[0]);
                }
                Logger.error(cause);
                throw new InvalidDataException(CorbaExceptionUtility.unpackMessage(cause));
            }
        } else if (job.hasQuery() && !"Query".equals(job.getActProp(BuiltInVertexProperties.OUTCOME_INIT))) {
            Logger.msg(3, "AgentProxy.execute(job) - executing query (OutcomeInit != Query)", new java.lang.Object[0]);
            job.setOutcome(item.executeQuery(job.getQuery()));
        }
lbl26:
        // 5 sources

        if (job.hasOutcome() && job.isOutcomeSet()) {
            job.getOutcome().validateAndCheck();
        }
        job.setAgentPath(this.mAgentPath);
        Logger.msg(3, "AgentProxy.execute(job) - submitting job to item proxy", new java.lang.Object[0]);
        result = item.requestAction(job);
        if (Logger.doLog(3)) {
            timeNow = new Date();
            secsNow = (timeNow.getTime() - startTime.getTime()) / 1000L;
            Logger.msg(3, "AgentProxy.execute(job) - execution DONE in " + secsNow + " seconds", new java.lang.Object[0]);
        }
        return result;
    }

    private ErrorInfo callScript(ItemProxy item, Job job) throws ScriptingEngineException, InvalidDataException, ObjectNotFoundException {
        Script script = job.getScript();
        CastorHashMap params = new CastorHashMap();
        params.put("item", item);
        params.put("agent", this);
        params.put("job", job);
        java.lang.Object returnVal = script.evaluate(item.getPath(), params, job.getStepPath(), true, null);
        if (returnVal instanceof Map) {
            return (ErrorInfo)((Map)returnVal).get(this.getErrorInfoParameterName(script));
        }
        if (returnVal instanceof ErrorInfo) {
            return (ErrorInfo)returnVal;
        }
        throw new InvalidDataException("Script " + script.getName() + " return value must be of org.cristalise.kernel.scripting.ErrorInfo");
    }

    private String getErrorInfoParameterName(Script script) throws InvalidDataException {
        Parameter p = script.getOutputParams().size() == 1 ? script.getOutputParams().values().iterator().next() : script.getOutputParams().get("errors");
        if (p.getType() != ErrorInfo.class) {
            throw new InvalidDataException("Script " + script.getName() + " must have at least one output of org.cristalise.kernel.scripting.ErrorInfo");
        }
        return p.getName();
    }

    public String execute(ItemProxy item, Class<?> predefStep, C2KLocalObject obj) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        return this.execute(item, predefStep.getSimpleName(), obj);
    }

    public String execute(ItemProxy item, String predefStep, C2KLocalObject obj) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        String param;
        try {
            param = this.marshall(obj);
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new InvalidDataException("Error on marshall");
        }
        return this.execute(item, predefStep, param);
    }

    public String execute(ItemProxy item, Class<?> predefStep, String[] params) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        return this.execute(item, predefStep.getSimpleName(), params);
    }

    public String execute(ItemProxy item, String predefStep, String[] params) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        String schemaName = PredefinedStep.getPredefStepSchemaName(predefStep);
        String param = schemaName.equals("PredefinedStepOutcome") ? PredefinedStep.bundleData(params) : params[0];
        return item.getItem().requestAction(this.mAgentPath.getSystemKey(), "workflow/predefined/" + predefStep, 0, param, "", new byte[0]);
    }

    public String execute(ItemProxy item, Class<?> predefStep, String param) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        return this.execute(item, predefStep.getSimpleName(), param);
    }

    public String execute(ItemProxy item, String predefStep, String param) throws AccessRightsException, InvalidDataException, InvalidTransitionException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        return this.execute(item, predefStep, new String[]{param});
    }

    public String marshall(java.lang.Object obj) throws Exception {
        return Gateway.getMarshaller().marshall(obj);
    }

    public java.lang.Object unmarshall(String obj) throws Exception {
        return Gateway.getMarshaller().unmarshall(obj);
    }

    public ItemProxy searchItem(String name) throws ObjectNotFoundException {
        return this.searchItem(new DomainPath(""), name);
    }

    public ItemProxy searchItem(Path root, String name) throws ObjectNotFoundException {
        Iterator<Path> results = Gateway.getLookup().search(root, name);
        Path returnPath = null;
        if (!results.hasNext()) {
            throw new ObjectNotFoundException(name);
        }
        while (results.hasNext()) {
            Path nextMatch = results.next();
            if (returnPath != null) {
                if (!this.isItemPathAndNotNull(nextMatch)) continue;
                if (!returnPath.getItemPath().getUUID().equals(nextMatch.getItemPath().getUUID())) {
                    throw new ObjectNotFoundException("Too many different items with name:" + name);
                }
                returnPath = nextMatch;
                continue;
            }
            if (!this.isItemPathAndNotNull(nextMatch)) continue;
            returnPath = nextMatch;
            Logger.msg(5, "AgentProxy.searchItem() - found for " + name + " UUID = " + returnPath.getItemPath().getUUID(), new java.lang.Object[0]);
        }
        if (returnPath == null) {
            throw new ObjectNotFoundException(name);
        }
        return Gateway.getProxyManager().getProxy(returnPath);
    }

    private boolean isItemPathAndNotNull(Path pPath) {
        boolean ok = false;
        try {
            ok = pPath.getItemPath() != null;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return ok;
    }

    public List<ItemProxy> searchItems(Path start, PropertyDescriptionList props) {
        Iterator<Path> results = Gateway.getLookup().search(start, props);
        return this.createItemProxyList(results);
    }

    public List<ItemProxy> searchItems(Path start, Property[] props) {
        Iterator<Path> results = Gateway.getLookup().search(start, props);
        return this.createItemProxyList(results);
    }

    private List<ItemProxy> createItemProxyList(Iterator<Path> results) {
        ArrayList<ItemProxy> returnList = new ArrayList<ItemProxy>();
        while (results.hasNext()) {
            Path nextMatch = results.next();
            try {
                returnList.add(Gateway.getProxyManager().getProxy(nextMatch));
            }
            catch (ObjectNotFoundException e) {
                Logger.error("Path '" + nextMatch + "' did not resolve to an Item", new java.lang.Object[0]);
            }
        }
        return returnList;
    }

    public ItemProxy getItem(String itemPath) throws ObjectNotFoundException {
        return this.getItem(new DomainPath(itemPath));
    }

    @Override
    public AgentPath getPath() {
        return this.mAgentPath;
    }

    public ItemProxy getItem(Path itemPath) throws ObjectNotFoundException {
        return Gateway.getProxyManager().getProxy(itemPath);
    }

    public ItemProxy getItemByUUID(String uuid) throws ObjectNotFoundException, InvalidItemPathException {
        return Gateway.getProxyManager().getProxy(new ItemPath(uuid));
    }

    public RolePath[] getRoles() {
        return Gateway.getLookup().getRoles(this.mAgentPath);
    }
}

