/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.ArrayList;
import java.util.Arrays;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.WriteProperty;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.Logger;

public class UpdateCollectionsFromDescription
extends PredefinedStep {
    public static final String description = "";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException, AccessRightsException {
        ItemPath descItemPath;
        String[] inputs = UpdateCollectionsFromDescription.getDataList(requestData);
        String descPath = inputs[0];
        String descVer = inputs[1];
        try {
            descItemPath = Gateway.getLookup().resolvePath(new DomainPath(descPath));
        }
        catch (InvalidItemPathException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
        PropertyArrayList newItemProps = new PropertyArrayList();
        ArrayList<String> currentCollNames = new ArrayList<String>(Arrays.asList(Gateway.getStorage().getClusterContents(item, ClusterType.COLLECTION)));
        for (String collName : Gateway.getStorage().getClusterContents(descItemPath, ClusterType.COLLECTION, locker)) {
            if (!currentCollNames.contains(collName)) {
                Collection<?> newColl = CreateItemFromDescription.instantiateCollection(collName, descItemPath, descVer, newItemProps, locker);
                if (newColl == null) continue;
                Gateway.getStorage().put(item, newColl, locker);
                continue;
            }
            currentCollNames.remove(collName);
        }
        for (Property p : newItemProps.list) {
            WriteProperty.write(item, p.getName(), p.getValue(), locker);
        }
        for (String collName : currentCollNames) {
            Gateway.getStorage().remove(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName, locker);
        }
        return requestData;
    }
}

