/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.item;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.CorbaServer;
import org.cristalise.kernel.entity.ItemOperations;
import org.cristalise.kernel.entity.TraceableEntity;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.CastorXMLUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class CreateItemFromDescription
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath descItemPath, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectAlreadyExistsException, CannotManageException, ObjectCannotBeUpdated, PersistencyException {
        String[] input = CreateItemFromDescription.getDataList(requestData);
        String newName = input[0];
        String domPath = input[1];
        String descVer = input.length > 2 && StringUtils.isNotBlank((CharSequence)input[2]) ? input[2] : "last";
        PropertyArrayList initProps = input.length > 3 && StringUtils.isNotBlank((CharSequence)input[3]) ? this.unmarshallInitProperties(input[3]) : new PropertyArrayList();
        String outcome = input.length > 4 && StringUtils.isNotBlank((CharSequence)input[4]) ? input[4] : "";
        Logger.msg(1, "CreateItemFromDescription - name:" + newName, new Object[0]);
        DomainPath context = new DomainPath(new DomainPath(domPath), newName);
        if (context.exists()) {
            throw new ObjectAlreadyExistsException("The path " + context + " exists already.");
        }
        Logger.msg(6, "CreateItemFromDescription - Requesting new item path", new Object[0]);
        ItemPath newItemPath = new ItemPath();
        Logger.msg(3, "CreateItemFromDescription - Creating Item", new Object[0]);
        CorbaServer factory = Gateway.getCorbaServer();
        if (factory == null) {
            throw new CannotManageException("This process cannot create new Items");
        }
        TraceableEntity newItem = factory.createItem(newItemPath);
        Gateway.getLookupManager().add(newItemPath);
        this.initialiseItem(newItem, agent, descItemPath, initProps, outcome, newName, descVer, context, newItemPath, locker);
        return requestData;
    }

    protected void initialiseItem(ItemOperations newItem, AgentPath agent, ItemPath descItemPath, PropertyArrayList initProps, String outcome, String newName, String descVer, DomainPath context, ItemPath newItemPath, Object locker) throws ObjectCannotBeUpdated, CannotManageException, InvalidDataException, ObjectAlreadyExistsException, PersistencyException, ObjectNotFoundException {
        Logger.msg(3, "CreateItemFromDescription.initialiseItem() - Initializing Item:" + newName, new Object[0]);
        try {
            PropertyArrayList newProps = this.instantiateProperties(descItemPath, descVer, initProps, newName, agent, locker);
            CollectionArrayList newColls = this.instantiateCollections(descItemPath, descVer, newProps, locker);
            CompositeActivity newWorkflow = this.instantiateWorkflow(descItemPath, descVer, locker);
            Viewpoint newViewpoint = this.instantiateViewpoint(descItemPath, descVer, locker);
            CastorXMLUtility xml = Gateway.getMarshaller();
            newItem.initialise(agent.getSystemKey(), xml.marshall(newProps), xml.marshall(newWorkflow), xml.marshall(newColls), newViewpoint != null ? xml.marshall(newViewpoint) : "", outcome != null ? outcome : "");
        }
        catch (IOException | AccessRightsException | InvalidCollectionModification | MappingException | MarshalException | ValidationException e) {
            Logger.error((Throwable)e);
            Gateway.getLookupManager().delete(newItemPath);
            throw new InvalidDataException("CreateItemFromDescription: Problem initializing new Item. See log: " + ((Throwable)e).getMessage());
        }
        catch (InvalidDataException | ObjectNotFoundException | PersistencyException e) {
            Logger.error((Throwable)e);
            Gateway.getLookupManager().delete(newItemPath);
            throw e;
        }
        Logger.msg(3, "CreateItemFromDescription - Creating " + context, new Object[0]);
        context.setItemPath(newItemPath);
        Gateway.getLookupManager().add(context);
    }

    protected PropertyArrayList unmarshallInitProperties(String initPropString) throws InvalidDataException {
        try {
            return (PropertyArrayList)Gateway.getMarshaller().unmarshall(initPropString);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Initial property parameter was not a marshalled PropertyArrayList: " + initPropString);
        }
    }

    protected PropertyArrayList instantiateProperties(ItemPath descItemPath, String descVer, PropertyArrayList initProps, String newName, AgentPath agent, Object locker) throws ObjectNotFoundException, InvalidDataException {
        PropertyDescriptionList pdList = PropertyUtility.getPropertyDescriptionOutcome(descItemPath, descVer, locker);
        PropertyArrayList props = pdList.instantiate(initProps);
        boolean foundName = false;
        for (Property prop : props.list) {
            if (!prop.getName().equals(BuiltInItemProperties.NAME.toString())) continue;
            foundName = true;
            prop.setValue(newName);
            break;
        }
        if (!foundName) {
            props.list.add(new Property(BuiltInItemProperties.NAME, newName, true));
        }
        props.list.add(new Property(BuiltInItemProperties.CREATOR, agent.getAgentName(), false));
        return props;
    }

    protected CompositeActivity instantiateWorkflow(ItemPath descItemPath, String descVer, Object locker) throws ObjectNotFoundException, InvalidDataException, PersistencyException {
        Collection thisCol = (Collection)Gateway.getStorage().get(descItemPath, (Object)((Object)ClusterType.COLLECTION) + "/" + (Object)((Object)BuiltInCollections.WORKFLOW) + "/" + descVer, locker);
        CollectionMember wfMember = (CollectionMember)thisCol.getMembers().list.get(0);
        String wfDefName = wfMember.resolveItem().getName();
        Object wfVerObj = wfMember.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
        if (wfVerObj == null || String.valueOf(wfVerObj).length() == 0) {
            throw new InvalidDataException("Workflow version number not set");
        }
        try {
            Integer wfDefVer = Integer.parseInt(wfVerObj.toString());
            if (wfDefName == null) {
                throw new InvalidDataException("No workflow given or defined");
            }
            CompositeActivityDef wfDef = (CompositeActivityDef)LocalObjectLoader.getActDef(wfDefName, wfDefVer);
            return (CompositeActivity)wfDef.instantiate();
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid workflow version number: " + wfVerObj.toString());
        }
        catch (ClassCastException ex) {
            Logger.error(ex);
            throw new InvalidDataException("Activity def '" + wfDefName + "' was not Composite");
        }
    }

    protected CollectionArrayList instantiateCollections(ItemPath descItemPath, String descVer, PropertyArrayList newProps, Object locker) throws ObjectNotFoundException, PersistencyException, InvalidDataException {
        String[] collNames;
        CollectionArrayList colls = new CollectionArrayList();
        for (String collName : collNames = Gateway.getStorage().getClusterContents(descItemPath, ClusterType.COLLECTION)) {
            Collection<?> newColl = CreateItemFromDescription.instantiateCollection(collName, descItemPath, descVer, newProps, locker);
            if (newColl == null) continue;
            colls.put(newColl);
        }
        return colls;
    }

    public static Collection<?> instantiateCollection(String collName, ItemPath descItemPath, String descVer, PropertyArrayList newProps, Object locker) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        Collection collOfDesc = (Collection)Gateway.getStorage().get(descItemPath, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/" + descVer, locker);
        Collection newColl = null;
        if (collOfDesc instanceof CollectionDescription) {
            Logger.msg(5, "CreateItemFromDescription - Instantiating CollectionDescription:" + collName, new Object[0]);
            CollectionDescription collDesc = (CollectionDescription)((Object)collOfDesc);
            newColl = collDesc.newInstance();
        } else if (collOfDesc instanceof Dependency) {
            Logger.msg(5, "CreateItemFromDescription - Instantiating Dependency:" + collName, new Object[0]);
            ((Dependency)collOfDesc).addToItemProperties(newProps);
        } else {
            throw new InvalidDataException("CANNOT instantiate collection:" + collName + " class:" + collOfDesc.getClass().getName());
        }
        return newColl;
    }

    protected Viewpoint instantiateViewpoint(ItemPath descItemPath, String descVer, Object locker) throws ObjectNotFoundException, InvalidDataException, PersistencyException {
        String collPath = (Object)((Object)ClusterType.COLLECTION) + "/" + (Object)((Object)BuiltInCollections.SCHEMA_INITIALISE);
        if (Gateway.getStorage().getClusterContents(descItemPath, collPath).length == 0) {
            return null;
        }
        Collection thisCol = (Collection)Gateway.getStorage().get(descItemPath, collPath + "/" + descVer, locker);
        CollectionMember schemaMember = (CollectionMember)thisCol.getMembers().list.get(0);
        String schemaName = schemaMember.resolveItem().getName();
        Object schemaVerObj = schemaMember.getProperties().getBuiltInProperty(BuiltInVertexProperties.VERSION);
        Object viewNameObj = schemaMember.getProperties().get("View");
        if (schemaName == null) {
            throw new InvalidDataException("No schema given or defined");
        }
        if (schemaVerObj == null || String.valueOf(schemaVerObj).length() == 0) {
            throw new InvalidDataException("schema version number not set");
        }
        try {
            Integer schemaVer = Integer.parseInt(schemaVerObj.toString());
            String viewName = viewNameObj == null ? "last" : viewNameObj.toString();
            return new Viewpoint(new ItemPath(), schemaName, viewName, schemaVer, -1);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid schema version number: " + schemaVerObj.toString());
        }
    }
}

