/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.property;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class PropertyUtility {
    public static String getValue(ArrayList<PropertyDescription> pdlist, String name) {
        for (PropertyDescription pd : pdlist) {
            if (!name.equalsIgnoreCase(pd.getName())) continue;
            return pd.getDefaultValue();
        }
        return null;
    }

    public static boolean propertyExists(ItemPath itemPath, String propName, Object locker) {
        try {
            String[] contents;
            for (String name : contents = Gateway.getStorage().getClusterContents(itemPath, ClusterType.PROPERTY)) {
                if (!name.equals(propName)) continue;
                return true;
            }
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)((Object)e));
        }
        return false;
    }

    public static Property getProperty(ItemPath itemPath, BuiltInItemProperties prop, Object locker) throws ObjectNotFoundException {
        return PropertyUtility.getProperty(itemPath, prop.getName(), locker);
    }

    public static Property getProperty(ItemPath itemPath, String propName, Object locker) throws ObjectNotFoundException {
        try {
            return (Property)Gateway.getStorage().get(itemPath, (Object)((Object)ClusterType.PROPERTY) + "/" + propName, locker);
        }
        catch (PersistencyException e) {
            Logger.error((Throwable)((Object)e));
            return null;
        }
    }

    public static String getNames(ArrayList<PropertyDescription> pdlist) {
        StringBuffer names = new StringBuffer();
        for (PropertyDescription value : pdlist) {
            names.append(value.getDefaultValue()).append(" ");
        }
        return names.toString();
    }

    public static String getClassIdNames(ArrayList<PropertyDescription> pdlist) {
        StringBuffer names = new StringBuffer();
        Iterator<PropertyDescription> iter = pdlist.iterator();
        while (iter.hasNext()) {
            PropertyDescription pd = iter.next();
            if (pd.getIsClassIdentifier()) {
                names.append(pd.getName());
            }
            if (!iter.hasNext()) continue;
            names.append(",");
        }
        return names.toString();
    }

    public static PropertyDescriptionList getPropertyDescriptionOutcome(ItemPath itemPath, String descVer, Object locker) throws ObjectNotFoundException {
        try {
            if (PropertyUtility.getProperty(itemPath, BuiltInItemProperties.TYPE, locker).getValue().equals(BuiltInResources.PROPERTY_DESC_RESOURCE.getSchemaName())) {
                String name = PropertyUtility.getProperty(itemPath, BuiltInItemProperties.NAME, locker).getValue();
                int version = PropertyUtility.getVersionID(itemPath, descVer, BuiltInResources.PROPERTY_DESC_RESOURCE.getSchemaName(), locker);
                return LocalObjectLoader.getPropertyDescriptionList(name, version);
            }
            Outcome outc = (Outcome)Gateway.getStorage().get(itemPath, (Object)((Object)ClusterType.VIEWPOINT) + "/PropertyDescription/" + descVer + "/data", locker);
            return (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(outc.getData());
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new ObjectNotFoundException("Could not fetch PropertyDescription from '" + itemPath + "' error:" + ex.getMessage());
        }
    }

    private static int getVersionID(ItemPath itemPath, String descVer, String schema, Object locker) throws PersistencyException, ObjectNotFoundException {
        int version = 0;
        if ("last".equals(descVer)) {
            String[] views = Gateway.getStorage().getClusterContents(itemPath, (Object)((Object)ClusterType.VIEWPOINT) + "/" + schema, locker);
            version = -1;
            for (int i = 0; i < views.length; ++i) {
                int aVersion;
                if (!StringUtils.isNumeric((CharSequence)views[i]) || version >= (aVersion = Integer.parseInt(views[i]))) continue;
                version = aVersion;
            }
            if (version == -1) {
                throw new ObjectNotFoundException(String.format("itemPath:%s schema:%s does not have any version", itemPath, schema));
            }
        } else if (StringUtils.isNumeric((CharSequence)descVer)) {
            version = Integer.parseInt(descVer);
        } else {
            throw new ObjectNotFoundException("descVer:'" + descVer + "' must be 'last' or positive integer");
        }
        return version;
    }

    public static CastorHashMap convertTransitiveProperties(PropertyDescriptionList pdList) {
        CastorHashMap props = new CastorHashMap();
        for (int i = 0; i < pdList.list.size(); ++i) {
            PropertyDescription pd = (PropertyDescription)pdList.list.get(i);
            if (!pd.isTransitive()) continue;
            props.put(pd.getName(), pd.getDefaultValue());
        }
        return props;
    }
}

