/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.UUID;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.Module;
import org.cristalise.kernel.process.module.ModuleResource;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.SoftCache;

public abstract class DescriptionObjectCache<D extends DescriptionObject> {
    SoftCache<String, CacheEntry<D>> cache = new SoftCache();
    Property[] classIdProps;

    public DescriptionObjectCache() {
        try {
            String propDescXML = Gateway.getResource().findTextResource("boot/property/" + this.getTypeCode() + "Prop.xml");
            PropertyDescriptionList propDescs = (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(propDescXML);
            ArrayList<Property> classIdPropList = new ArrayList<Property>();
            for (PropertyDescription propDesc : propDescs.list) {
                if (!propDesc.getIsClassIdentifier()) continue;
                classIdPropList.add(propDesc.getProperty());
            }
            this.classIdProps = classIdPropList.toArray(new Property[classIdPropList.size()]);
        }
        catch (Exception ex) {
            Logger.error(ex);
            Logger.error("Could not load property description for " + this.getTypeCode() + ". Cannot filter.", new Object[0]);
            this.classIdProps = new Property[0];
        }
    }

    public D loadObjectFromBootstrap(String name) throws InvalidDataException, ObjectNotFoundException {
        try {
            Logger.msg(3, "DescriptionObjectCache.loadObjectFromBootstrap() - name:" + name + " Loading it from kernel items", new Object[0]);
            String bootItems = FileStringUtility.url2String(Gateway.getResource().getKernelResourceURL("boot/allbootitems.txt"));
            StringTokenizer str = new StringTokenizer(bootItems, "\n\r");
            while (str.hasMoreTokens()) {
                String resLine = str.nextToken();
                String[] resElem = resLine.split(",");
                if (!resElem[0].equals(name) && !this.isBootResource(resElem[1], name)) continue;
                Logger.msg(3, "DescriptionObjectCache.loadObjectFromBootstrap() - Shimming " + this.getTypeCode() + " " + name + " from bootstrap", new Object[0]);
                String resData = Gateway.getResource().getTextResource(null, "boot/" + resElem[1] + (resElem[1].startsWith("OD") ? ".xsd" : ".xml"));
                return this.buildObject(name, 0, new ItemPath(resElem[0]), resData);
            }
            for (Module module : Gateway.getModuleManager().getModules()) {
                Logger.msg(3, "DescriptionObjectCache.loadObjectFromBootstrap() - name:" + name + " Lodaing it from module:" + module.getName(), new Object[0]);
                ModuleResource res = (ModuleResource)module.getImports().findImport(name);
                if (res == null) continue;
                res.setNs(module.getNs());
                String resData = Gateway.getResource().getTextResource(module.getNs(), res.getResourceLocation());
                String uuid = res.getID() == null ? UUID.randomUUID().toString() : res.getID();
                return this.buildObject(name, 0, new ItemPath(uuid), resData);
            }
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Error finding bootstrap resources");
        }
        throw new ObjectNotFoundException("Resource " + this.getSchemaName() + " " + name + " not found in bootstrap resources");
    }

    protected boolean isBootResource(String filename, String resName) {
        return filename.equals(this.getTypeCode() + "/" + resName);
    }

    public ItemPath findItem(String name) throws ObjectNotFoundException, InvalidDataException {
        if (Gateway.getLookup() == null) {
            throw new ObjectNotFoundException("Cannot find Items without a Lookup");
        }
        try {
            ItemPath resItem = new ItemPath(name);
            if (resItem.exists()) {
                return resItem;
            }
        }
        catch (InvalidItemPathException resItem) {
            // empty catch block
        }
        DomainPath directPath = new DomainPath(name);
        if (directPath.exists() && directPath.getItemPath() != null) {
            return directPath.getItemPath();
        }
        Property[] searchProps = new Property[this.classIdProps.length + 1];
        searchProps[0] = new Property(BuiltInItemProperties.NAME, name);
        System.arraycopy(this.classIdProps, 0, searchProps, 1, this.classIdProps.length);
        Iterator<Path> e = Gateway.getLookup().search((Path)new DomainPath(), searchProps);
        if (e.hasNext()) {
            Path defPath = e.next();
            if (e.hasNext()) {
                throw new ObjectNotFoundException("Too many matches for " + this.getTypeCode() + " " + name);
            }
            if (defPath.getItemPath() == null) {
                throw new InvalidDataException(this.getTypeCode() + " " + name + " was found, but was not an Item");
            }
            return defPath.getItemPath();
        }
        throw new ObjectNotFoundException("No match for " + this.getTypeCode() + " " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D get(String name, int version) throws ObjectNotFoundException, InvalidDataException {
        DescriptionObject thisDef = null;
        SoftCache<String, CacheEntry<D>> softCache = this.cache;
        synchronized (softCache) {
            CacheEntry<D> thisDefEntry = this.cache.get(name + "_" + version);
            if (thisDefEntry == null) {
                Logger.msg(6, "DescriptionObjectCache.get() - " + name + " v" + version + " not found in cache. Checking id.", new Object[0]);
                try {
                    ItemPath defItemPath = this.findItem(name);
                    String defId = defItemPath.getUUID().toString();
                    thisDefEntry = this.cache.get(defId + "_" + version);
                    if (thisDefEntry == null) {
                        String itemName;
                        Logger.msg(6, "DescriptionObjectCache.get() - " + name + " v" + version + " not found in cache. Loading from database.", new Object[0]);
                        ItemProxy defItemProxy = Gateway.getProxyManager().getProxy(defItemPath);
                        if (name.equals(defId) && (itemName = defItemProxy.getName()) != null) {
                            name = itemName;
                        }
                        thisDef = (DescriptionObject)this.loadObject(name, version, defItemProxy);
                        this.cache.put(defId + "_" + version, new CacheEntry(this, thisDef, defItemProxy, this));
                    }
                }
                catch (ObjectNotFoundException ex) {
                    if (version == 0) {
                        try {
                            return this.loadObjectFromBootstrap(name);
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            // empty catch block
                        }
                    }
                    throw ex;
                }
            }
            if (thisDefEntry != null && thisDef == null) {
                Logger.msg(6, "DescriptionObjectCache.get() - " + name + " v" + version + " found in cache.", new Object[0]);
                thisDef = (DescriptionObject)thisDefEntry.def;
            }
        }
        return (D)thisDef;
    }

    public abstract String getTypeCode();

    public abstract String getSchemaName();

    public abstract D buildObject(String var1, int var2, ItemPath var3, String var4) throws InvalidDataException;

    public D loadObject(String name, int version, ItemProxy proxy) throws ObjectNotFoundException, InvalidDataException {
        String rawRes;
        Viewpoint smView = (Viewpoint)proxy.getObject((Object)((Object)ClusterType.VIEWPOINT) + "/" + this.getSchemaName() + "/" + version);
        try {
            rawRes = smView.getOutcome().getData();
        }
        catch (PersistencyException ex) {
            Logger.error((Throwable)((Object)ex));
            throw new ObjectNotFoundException("Problem loading " + this.getSchemaName() + " " + name + " v" + version + ": " + ex.getMessage());
        }
        return this.buildObject(name, version, proxy.getPath(), rawRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(String id) {
        SoftCache<String, CacheEntry<D>> softCache = this.cache;
        synchronized (softCache) {
            if (this.cache.keySet().contains(id)) {
                Logger.msg(7, "DescriptionObjectCache.remove() - activityDef:" + id, new Object[0]);
                this.cache.remove(id);
            }
        }
    }

    public static class CacheEntry<E extends DescriptionObject>
    implements ProxyObserver<Viewpoint> {
        public String id;
        public ItemProxy proxy;
        public E def;
        public DescriptionObjectCache<E> parent;
        final /* synthetic */ DescriptionObjectCache this$0;

        public CacheEntry(E def, ItemProxy proxy, DescriptionObjectCache<E> parent) {
            this.this$0 = this$0;
            this.id = def.getItemID() + "_" + def.getVersion();
            this.def = def;
            this.parent = parent;
            this.proxy = proxy;
            proxy.subscribe(new MemberSubscription<Viewpoint>(this, ClusterType.VIEWPOINT.getName(), false));
        }

        public void finalize() {
            this.parent.removeObject(this.id);
            this.proxy.unsubscribe(this);
        }

        @Override
        public void add(Viewpoint contents) {
            this.parent.removeObject(this.id);
        }

        @Override
        public void remove(String oldId) {
            this.parent.removeObject(this.id);
        }

        public String toString() {
            return "Cache entry: " + this.id;
        }

        @Override
        public void control(String control, String msg) {
        }
    }
}

