/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.ArrayList;
import java.util.List;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;

public class Dependency
extends Collection<DependencyMember> {
    protected CastorHashMap mProperties = new CastorHashMap();
    protected String mClassProps = "";

    public Dependency() {
        this.setName("Dependency");
    }

    public Dependency(String name) {
        this.setName(name);
    }

    public Dependency(String name, Integer version) {
        this.setName(name);
        this.setVersion(version);
    }

    public Dependency(BuiltInCollections collection) {
        this(collection.getName());
    }

    public Dependency(BuiltInCollections collection, Integer version) {
        this(collection.getName(), version);
    }

    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    public void setClassProps(String classProps) {
        this.mClassProps = classProps;
    }

    public String getClassProps() {
        return this.mClassProps;
    }

    public Property[] getClassProperties() {
        String[] classPropNames = this.getClassProps().split(",");
        Property[] props = new Property[classPropNames.length];
        int i = 0;
        for (String propName : classPropNames) {
            props[i++] = new Property(propName, (String)this.getProperties().get(propName));
        }
        return props;
    }

    public void updateMember(ItemPath childPath, CastorHashMap memberNewProps) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        this.updateMember(childPath, -1, memberNewProps);
    }

    public void updateMember(ItemPath childPath, int memberID, CastorHashMap memberNewProps) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        List members = this.resolveMembers(memberID, childPath);
        if (members.size() != 1) {
            throw new InvalidDataException("Child item '" + childPath + "' apperars more them once in collection " + this.mName);
        }
        DependencyMember member = (DependencyMember)members.get(0);
        member.updateProperties(memberNewProps);
    }

    public DependencyMember addMember(ItemPath itemPath) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        DependencyMember depMember = this.createMember(itemPath);
        this.mMembers.list.add(depMember);
        Logger.msg(8, "Dependency.addMember(" + itemPath + ") added to children with slotId:" + depMember.getID(), new Object[0]);
        return depMember;
    }

    public void addMember(DependencyMember depMember) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        this.mMembers.list.add(depMember);
    }

    public DependencyMember createMember(ItemPath itemPath) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        if (itemPath == null) {
            throw new InvalidCollectionModification("Cannot add empty slot to Dependency collection");
        }
        if (this.contains(itemPath)) {
            throw new ObjectAlreadyExistsException("Item " + itemPath + " already exists in Dependency " + this.getName());
        }
        DependencyMember depMember = new DependencyMember();
        depMember.setID(this.getCounter());
        depMember.setProperties((CastorHashMap)this.mProperties.clone());
        depMember.setClassProps(this.mClassProps);
        depMember.assignItem(itemPath);
        return depMember;
    }

    public List<DependencyMember> compare(Dependency other) {
        ArrayList<DependencyMember> newMembers = new ArrayList<DependencyMember>();
        for (DependencyMember thisMember : other.getMembers().list) {
            if (this.contains(thisMember.getItemPath())) continue;
            newMembers.add(thisMember);
        }
        return newMembers;
    }

    @Override
    public DependencyMember addMember(ItemPath itemPath, CastorHashMap props, String classProps) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        DependencyMember depMember = this.createMember(itemPath, props);
        this.mMembers.list.add(depMember);
        Logger.msg(8, "Dependency.addMember(" + itemPath + ") added to children with slotId:" + depMember.getID(), new Object[0]);
        return depMember;
    }

    public DependencyMember createMember(ItemPath itemPath, CastorHashMap props) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        if (itemPath == null) {
            throw new InvalidCollectionModification("Cannot add empty slot to Dependency collection");
        }
        boolean checkUniqueness = Gateway.getProperties().getBoolean("Dependency.checkMemberUniqueness", true);
        if (checkUniqueness && this.contains(itemPath)) {
            throw new ObjectAlreadyExistsException("Item " + itemPath + " already exists in Dependency " + this.getName());
        }
        for (String classProp : this.mClassProps.split(",")) {
            if (!props.containsKey(classProp)) continue;
            throw new InvalidCollectionModification("Dependency cannot change classProperties:" + this.mClassProps);
        }
        DependencyMember depMember = new DependencyMember();
        depMember.setID(this.getCounter());
        for (String classProp : this.mClassProps.split(",")) {
            props.put(classProp, this.mProperties.get(classProp));
        }
        depMember.setProperties(props);
        depMember.setClassProps(this.mClassProps);
        depMember.assignItem(itemPath);
        return depMember;
    }

    @Override
    public void removeMember(int memberId) throws ObjectNotFoundException {
        for (DependencyMember element : this.mMembers.list) {
            if (element.getID() != memberId) continue;
            this.mMembers.list.remove(element);
            return;
        }
        throw new ObjectNotFoundException("Collection name:" + this.getName() + " does not contains Member id:" + memberId);
    }

    public void addToItemProperties(PropertyArrayList props) throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(2, "Dependency.addToItemProperties(" + this.getName() + ") - Starting ...", new Object[0]);
        BuiltInCollections builtInColl = BuiltInCollections.getValue(this.getName());
        block7: for (DependencyMember member : this.getMembers().list) {
            String memberUUID = member.getChildUUID();
            Integer memberVer = LocalObjectLoader.deriveVersionNumber(member.getBuiltInProperty(BuiltInVertexProperties.VERSION));
            if (memberVer == null) {
                throw new InvalidDataException("Version is null for Collection:" + this.getName() + ", MemberUUID:" + memberUUID);
            }
            if (this.convertToItemPropertyByScript(props, member) || builtInColl == null) continue;
            Logger.msg(5, "Dependency.addToItemProperties() - BuiltIn Dependency:" + this.getName() + " memberUUID:" + memberUUID, new Object[0]);
            switch (builtInColl) {
                case SCHEMA: {
                    LocalObjectLoader.getSchema(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.SCHEMA_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
                case SCRIPT: {
                    LocalObjectLoader.getScript(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.SCRIPT_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
                case QUERY: {
                    LocalObjectLoader.getQuery(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.QUERY_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
                case STATE_MACHINE: {
                    if (!Gateway.getProperties().getBoolean("Dependency.addStateMachineURN", false)) continue block7;
                    LocalObjectLoader.getStateMachine(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.STATE_MACHINE_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
                case WORKFLOW: {
                    if (!Gateway.getProperties().getBoolean("Dependency.addWorkflowURN", false)) continue block7;
                    LocalObjectLoader.getCompActDef(memberUUID, memberVer);
                    props.put(new Property(BuiltInItemProperties.WORKFLOW_URN, memberUUID + ":" + memberVer));
                    continue block7;
                }
            }
            Logger.msg(8, "Dependency.addToItemProperties() - Cannot handle BuiltIn Dependency:" + this.getName(), new Object[0]);
        }
    }

    private boolean convertToItemPropertyByScript(PropertyArrayList props, DependencyMember member) throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(5, "Dependency.convertToItemPropertyByScript() - Dependency:" + this.getName() + " memberUUID:" + member.getChildUUID(), new Object[0]);
        String scriptName = (String)member.getBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME);
        if (scriptName != null && scriptName.length() > 0) {
            PropertyArrayList newProps = (PropertyArrayList)member.evaluateScript();
            props.merge(newProps);
            return true;
        }
        return false;
    }

    public void addToVertexProperties(CastorHashMap props) throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(2, "Dependency.addToVertexProperties(" + this.getName() + ") - Starting ...", new Object[0]);
        BuiltInCollections builtInColl = BuiltInCollections.getValue(this.getName());
        block15: for (DependencyMember member : this.getMembers().list) {
            String memberUUID = member.getChildUUID();
            Integer memberVer = LocalObjectLoader.deriveVersionNumber(member.getBuiltInProperty(BuiltInVertexProperties.VERSION));
            if (memberVer == null) {
                throw new InvalidDataException("Version is null for Collection:" + this.getName() + ", DependencyMember:" + memberUUID);
            }
            if (this.convertToVertextPropsByScript(props, member) || builtInColl == null) continue;
            Logger.msg(5, "Dependency.addToVertexProperties() - Dependency:" + this.getName() + " memberUUID:" + memberUUID, new Object[0]);
            switch (builtInColl) {
                case SCHEMA: {
                    String uuid;
                    try {
                        LocalObjectLoader.getSchema(memberUUID, memberVer);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, (Object)memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_VERSION, (Object)memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey(BuiltInVertexProperties.SCHEMA_NAME.getName())) continue block15;
                        Logger.msg(8, "Dependency.addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties", new Object[0]);
                        uuid = LocalObjectLoader.getSchema(props).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, (Object)uuid);
                    }
                    break;
                }
                case SCRIPT: {
                    String uuid;
                    try {
                        LocalObjectLoader.getScript(memberUUID, memberVer);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME, (Object)memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_VERSION, (Object)memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey(BuiltInVertexProperties.SCRIPT_NAME.getName())) continue block15;
                        Logger.msg(8, "Dependency.addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties", new Object[0]);
                        uuid = LocalObjectLoader.getScript(props).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME, (Object)uuid);
                    }
                    break;
                }
                case QUERY: {
                    String uuid;
                    try {
                        LocalObjectLoader.getQuery(memberUUID, memberVer);
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_NAME, (Object)memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_VERSION, (Object)memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey(BuiltInVertexProperties.QUERY_NAME.getName())) continue block15;
                        Logger.msg(8, "Dependency.addToVertexProperties() - BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties", new Object[0]);
                        uuid = LocalObjectLoader.getQuery(props).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.QUERY_NAME, (Object)uuid);
                    }
                    break;
                }
                case STATE_MACHINE: {
                    String uuid;
                    try {
                        LocalObjectLoader.getStateMachine(memberUUID, memberVer);
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, (Object)memberUUID);
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_VERSION, (Object)memberVer);
                    }
                    catch (ObjectNotFoundException e) {
                        if (!props.containsKey(BuiltInVertexProperties.STATE_MACHINE_NAME.getName())) continue block15;
                        Logger.msg(8, "Dependency.addToVertexProperties() -  BACKWARD COMPABILITY: Dependency '" + this.getName() + "' is defined in Properties", new Object[0]);
                        uuid = LocalObjectLoader.getStateMachine(props).getItemPath().getUUID().toString();
                        props.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, (Object)uuid);
                    }
                    break;
                }
                case ACTIVITY: {
                    ActivityDef actDef = LocalObjectLoader.getActDef(memberUUID, memberVer);
                    CastorHashMap chm = null;
                    if (props.containsKey(BuiltInVertexProperties.ACTIVITY_DEF_URN.getName())) {
                        chm = (CastorHashMap)props.getBuiltInProperty(BuiltInVertexProperties.ACTIVITY_DEF_URN);
                    } else {
                        chm = new CastorHashMap();
                        props.setBuiltInProperty(BuiltInVertexProperties.ACTIVITY_DEF_URN, (Object)chm);
                    }
                    Logger.msg(8, "Dependency.addToVertexProperties(" + this.getName() + ") - actDef:" + actDef.getActName(), new Object[0]);
                    chm.put(actDef.getActName(), memberUUID + "~" + memberVer);
                    break;
                }
                default: {
                    Logger.msg(8, "Dependency.addToVertexProperties() - Cannot handle BuiltIn Dependency:" + this.getName(), new Object[0]);
                }
            }
        }
    }

    private boolean convertToVertextPropsByScript(CastorHashMap props, DependencyMember member) throws InvalidDataException, ObjectNotFoundException {
        Logger.msg(5, "Dependency.convertToVertextPropsByScript() - Dependency:" + this.getName() + " memberUUID:" + member.getChildUUID(), new Object[0]);
        String scriptName = (String)member.getBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME);
        if (scriptName != null && scriptName.length() > 0) {
            CastorHashMap newProps = (CastorHashMap)member.evaluateScript();
            props.merge(newProps);
            return true;
        }
        return false;
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop) {
        return this.mProperties.get(prop.getName());
    }

    public boolean containsBuiltInProperty(BuiltInVertexProperties prop) {
        return this.mProperties.containsKey(prop.getName());
    }
}

