/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.Logger;

public class DependencyDescription
extends Dependency
implements CollectionDescription<DependencyMember> {
    public DependencyDescription() {
        this.setName("DependencyDescription");
    }

    public DependencyDescription(String name) {
        this.setName(name);
    }

    public DependencyDescription(String name, Integer version) {
        this.setName(name);
        this.setVersion(version);
    }

    @Override
    public Collection<DependencyMember> newInstance() throws ObjectNotFoundException {
        String depName = this.getName().replaceFirst("'$", "");
        Dependency newDep = new Dependency(depName);
        if (this.mMembers.list.size() == 1) {
            DependencyMember mem = (DependencyMember)this.mMembers.list.get(0);
            String descVer = this.getDescVer(mem);
            PropertyDescriptionList pdList = PropertyUtility.getPropertyDescriptionOutcome(mem.getItemPath(), descVer, null);
            if (pdList != null) {
                newDep.setProperties(PropertyUtility.convertTransitiveProperties(pdList));
                newDep.setClassProps(pdList.getClassProps());
            } else {
                Logger.warning("DependencyDescription.newInstance(" + this.getName() + ") - No PropertyDesc was found. Dependency cannot check member type.", new Object[0]);
            }
            if (this.mProperties != null) {
                newDep.getProperties().merge(this.mProperties);
            }
        } else {
            Logger.warning("DependencyDescription.newInstance(" + this.getName() + ") - No PropertyDesc was found. Dependency cannot check member type.", new Object[0]);
        }
        return newDep;
    }

    @Override
    public DependencyMember addMember(ItemPath itemPath) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        this.checkMembership();
        return super.addMember(itemPath);
    }

    @Override
    public DependencyMember addMember(ItemPath itemPath, CastorHashMap props, String classProps) throws InvalidCollectionModification, ObjectAlreadyExistsException {
        this.checkMembership();
        return super.addMember(itemPath, props, classProps);
    }

    public void checkMembership() throws InvalidCollectionModification {
        if (this.mMembers.list.size() > 0) {
            throw new InvalidCollectionModification("Dependency descriptions may not have more than one member.");
        }
    }
}

