/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepCollectionBase;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.CastorHashMap;

public class AddMemberToCollection
extends PredefinedStepCollectionBase {
    public static final String description = "Creates a new member slot for the given item in a dependency, and assigns the item";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectAlreadyExistsException, PersistencyException, ObjectNotFoundException, InvalidCollectionModification {
        String[] params = this.unpackParamsAndGetCollection(item, requestData, locker);
        Dependency dep = this.getDependency();
        DependencyMember member = null;
        member = this.memberNewProps == null ? dep.createMember(this.childPath) : dep.createMember(this.childPath, this.memberNewProps);
        if (dep.containsBuiltInProperty(BuiltInVertexProperties.MEMBER_ADD_SCRIPT)) {
            CastorHashMap scriptProps = new CastorHashMap();
            scriptProps.put("collection", dep);
            scriptProps.put("member", member);
            this.evaluateScript(item, (String)dep.getBuiltInProperty(BuiltInVertexProperties.MEMBER_ADD_SCRIPT), scriptProps, locker);
        }
        dep.addMember(member);
        Gateway.getStorage().put(item, dep, locker);
        params = Arrays.copyOf(params, params.length + 1);
        params[params.length - 1] = Integer.toString(member.getID());
        return AddMemberToCollection.bundleData(params);
    }
}

