/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.agent;

import java.util.ArrayList;
import java.util.Arrays;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class SetAgentRoles
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException {
        AgentPath targetAgent;
        Object[] params = SetAgentRoles.getDataList(requestData);
        Logger.msg(3, "SetAgentRoles: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params), new Object[0]);
        try {
            targetAgent = new AgentPath(item);
        }
        catch (InvalidItemPathException ex) {
            throw new InvalidDataException("Could not resolve syskey " + item + " as an Agent.");
        }
        RolePath[] currentRoles = targetAgent.getRoles();
        ArrayList<RolePath> requestedRoles = new ArrayList<RolePath>();
        for (int i = 0; i < params.length; ++i) {
            try {
                requestedRoles.add(Gateway.getLookup().getRolePath((String)params[i]));
                continue;
            }
            catch (ObjectNotFoundException e) {
                throw new InvalidDataException("Role " + (String)params[i] + " not found");
            }
        }
        ArrayList<RolePath> rolesToRemove = new ArrayList<RolePath>();
        for (RolePath existingRole : currentRoles) {
            if (requestedRoles.contains(existingRole)) {
                requestedRoles.remove(existingRole);
                continue;
            }
            rolesToRemove.add(existingRole);
        }
        for (RolePath roleToRemove : rolesToRemove) {
            try {
                Gateway.getLookupManager().removeRole(targetAgent, roleToRemove);
            }
            catch (Exception e) {
                Logger.error(e);
                throw new InvalidDataException("Error removing role " + roleToRemove.getName());
            }
        }
        for (RolePath roleToAdd : requestedRoles) {
            try {
                Gateway.getLookupManager().addRole(targetAgent, roleToAdd);
            }
            catch (Exception e) {
                Logger.error(e);
                throw new InvalidDataException("Error adding role " + roleToAdd.getName());
            }
        }
        return requestData;
    }
}

