/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.renderer.DirectedEdgeRenderer;
import org.cristalise.kernel.graph.renderer.VertexRenderer;
import org.cristalise.kernel.lifecycle.renderer.WfDirectedEdgeDefRenderer;
import org.cristalise.kernel.lifecycle.renderer.WfDirectedEdgeRenderer;
import org.cristalise.kernel.lifecycle.renderer.WfVertexDefRenderer;
import org.cristalise.kernel.lifecycle.renderer.WfVertexRenderer;
import org.cristalise.kernel.utils.Logger;

public class LifecycleRenderer {
    GraphModel mGraphModel;
    DirectedEdgeRenderer mDirectedEdgeRenderer;
    VertexRenderer mVertexRenderer;

    public LifecycleRenderer(GraphModel graphModel, boolean defGeneration) {
        this.mGraphModel = graphModel;
        if (defGeneration) {
            this.mDirectedEdgeRenderer = new WfDirectedEdgeDefRenderer();
            this.mVertexRenderer = new WfVertexDefRenderer();
        } else {
            this.mDirectedEdgeRenderer = new WfDirectedEdgeRenderer();
            this.mVertexRenderer = new WfVertexRenderer();
        }
    }

    public int getZoomFactor(int maxHeight, int maxWidth) {
        int width = this.mGraphModel.getWidth();
        int height = this.mGraphModel.getHeight();
        return maxHeight == 0 && maxWidth == 0 ? 100 : Math.min(maxWidth * 100 / width, Math.min(maxHeight * 100 / height, 100));
    }

    public BufferedImage getWorkFlowModelImage(int maxHeight, int maxWidth) throws IOException {
        int width = this.mGraphModel.getWidth();
        int height = this.mGraphModel.getHeight();
        int zoomFactor = this.getZoomFactor(maxHeight, maxWidth);
        BufferedImage img = new BufferedImage(width * zoomFactor / 100, height * zoomFactor / 100, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.scale((double)zoomFactor / 100.0, (double)zoomFactor / 100.0);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        this.draw(g2d);
        return img;
    }

    public void draw(Graphics2D g2d) {
        int i;
        if (this.mGraphModel == null) {
            Logger.warning("LifecycleGenerator.draw() - GraphModel is NULL!", new Object[0]);
            return;
        }
        DirectedEdge[] edges = this.mGraphModel.getEdges();
        Vertex[] vertices = this.mGraphModel.getVertices();
        for (i = 0; i < edges.length; ++i) {
            this.mDirectedEdgeRenderer.draw(g2d, edges[i]);
        }
        for (i = 0; i < vertices.length; ++i) {
            this.mVertexRenderer.draw(g2d, vertices[i]);
        }
        g2d.setPaint(Color.green);
        Vertex startVertex = this.mGraphModel.getStartVertex();
        if (startVertex != null) {
            this.drawVertexHighlight(g2d, startVertex, 1);
        }
    }

    protected void drawEdgeHighlight(Graphics2D g2d, DirectedEdge edge) {
        GraphPoint originPoint = edge.getOriginPoint();
        GraphPoint terminusPoint = edge.getTerminusPoint();
        int midX = originPoint.x + (terminusPoint.x - originPoint.x) / 2;
        int midY = originPoint.y + (terminusPoint.y - originPoint.y) / 2;
        int minX = midX - 10;
        int minY = midY - 10;
        int maxX = midX + 10;
        int maxY = midY + 10;
        g2d.drawLine(minX, minY, maxX, minY);
        g2d.drawLine(maxX, minY, maxX, maxY);
        g2d.drawLine(maxX, maxY, minX, maxY);
        g2d.drawLine(minX, maxY, minX, minY);
    }

    protected void drawVertexHighlight(Graphics2D g2d, Vertex vertex, int dist) {
        GraphPoint[] outlinePoints = vertex.getOutlinePoints();
        GraphPoint centrePoint = vertex.getCentrePoint();
        for (int i = 0; i < outlinePoints.length - 1; ++i) {
            LifecycleRenderer.drawShiftedLine(dist, g2d, centrePoint, outlinePoints[i].x, outlinePoints[i].y, outlinePoints[i + 1].x, outlinePoints[i + 1].y);
        }
        LifecycleRenderer.drawShiftedLine(dist, g2d, centrePoint, outlinePoints[outlinePoints.length - 1].x, outlinePoints[outlinePoints.length - 1].y, outlinePoints[0].x, outlinePoints[0].y);
    }

    private static void drawShiftedLine(int dist, Graphics2D g2d, GraphPoint centrePoint, int x1, int y1, int x2, int y2) {
        if (x1 > centrePoint.x) {
            x1 += dist;
        }
        if (x1 < centrePoint.x) {
            x1 -= dist;
        }
        if (y1 > centrePoint.y) {
            y1 += dist;
        }
        if (y1 < centrePoint.y) {
            y1 -= dist;
        }
        if (x2 > centrePoint.x) {
            x2 += dist;
        }
        if (x2 < centrePoint.x) {
            x2 -= dist;
        }
        if (y2 > centrePoint.y) {
            y2 += dist;
        }
        if (y2 < centrePoint.y) {
            y2 -= dist;
        }
        g2d.drawLine(x1, y1, x2, y2);
    }
}

