/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.ArrayList;
import java.util.List;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.LifecycleVertexOutlineCreator;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.AndSplit;
import org.cristalise.kernel.lifecycle.instance.Join;
import org.cristalise.kernel.lifecycle.instance.Loop;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.OrSplit;
import org.cristalise.kernel.lifecycle.instance.Split;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.XOrSplit;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.utils.Logger;

public class CompositeActivity
extends Activity {
    public CompositeActivity() {
        this.setBuiltInProperty(BuiltInVertexProperties.ABORTABLE, false);
        this.setBuiltInProperty(BuiltInVertexProperties.REPEAT_WHEN, false);
        this.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, "CompositeActivity");
        try {
            this.setChildrenGraphModel(new GraphModel(new LifecycleVertexOutlineCreator()));
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        this.setIsComposite(true);
    }

    @Override
    public void setChildrenGraphModel(GraphModel childrenGraph) throws InvalidDataException {
        super.setChildrenGraphModel(childrenGraph);
        childrenGraph.setVertexOutlineCreator(new LifecycleVertexOutlineCreator());
    }

    @Override
    public boolean verify() {
        boolean err = super.verify();
        GraphableVertex[] vChildren = this.getChildren();
        for (int i = 0; i < vChildren.length; ++i) {
            if (((WfVertex)vChildren[i]).verify()) continue;
            this.mErrors.add("error in children");
            return false;
        }
        return err;
    }

    public void initChild(WfVertex vertex, boolean first, GraphPoint point) {
        this.safeAddChild(vertex, point);
        if (first) {
            this.setFirstVertex(vertex.getID());
        }
    }

    public void setFirstVertex(int vertexID) {
        Logger.msg(5, "org.cristalise.kernel.lifecycle.CompositeActivity::setFirstVertex() vertexID:" + vertexID, new Object[0]);
        this.getChildrenGraphModel().setStartVertexId(vertexID);
    }

    private void safeAddChild(GraphableVertex v, GraphPoint g) {
        GraphPoint p = null;
        if (g != null) {
            p = new GraphPoint(g.x, g.y);
        }
        this.addChild(v, p);
    }

    public WfVertex newExistingChild(Activity child, String Name, GraphPoint point) {
        child.setName(Name);
        this.safeAddChild(child, point);
        return child;
    }

    public WfVertex newChild(String Name, String Type2, GraphPoint point) {
        WfVertex v = this.newChild(Type2, point);
        v.setName(Name);
        return v;
    }

    public WfVertex newChild(String vertexTypeId, GraphPoint point) {
        return this.newChild(WfVertex.Types.valueOf(vertexTypeId), "False id", false, point);
    }

    public WfVertex newChild(WfVertex.Types type, String name, boolean first, GraphPoint point) {
        switch (type) {
            case Atomic: {
                return this.newAtomChild(name, first, point);
            }
            case Composite: {
                return this.newCompChild(name, first, point);
            }
            case OrSplit: {
                return this.newSplitChild(name, "Or", first, point);
            }
            case XOrSplit: {
                return this.newSplitChild(name, "XOr", first, point);
            }
            case AndSplit: {
                return this.newSplitChild(name, "And", first, point);
            }
            case LoopSplit: {
                return this.newSplitChild(name, "Loop", first, point);
            }
            case Join: {
                return this.newJoinChild(name, "Join", first, point);
            }
            case Route: {
                return this.newJoinChild(name, "Route", first, point);
            }
        }
        throw new IllegalArgumentException("Unhandled enum value of WfVertex.Type:" + type.name());
    }

    public CompositeActivity newCompChild(String id, boolean first, GraphPoint point) {
        CompositeActivity act = new CompositeActivity();
        this.initChild(act, first, point);
        act.setName(id);
        return act;
    }

    public Activity newAtomChild(String id, boolean first, GraphPoint point) {
        Activity act = new Activity();
        this.initChild(act, first, point);
        act.setName(id);
        return act;
    }

    public Split newSplitChild(String name, String Type2, boolean first, GraphPoint point) {
        Split split = null;
        split = Type2.equals("Or") ? new OrSplit() : (Type2.equals("XOr") ? new XOrSplit() : (Type2.equals("Loop") ? new Loop() : new AndSplit()));
        this.initChild(split, first, point);
        split.setName(name);
        return split;
    }

    public Join newJoinChild(String name, String type, boolean first, GraphPoint point) {
        Join join = new Join();
        join.getProperties().put("Type", type);
        this.initChild(join, first, point);
        join.setName(name);
        return join;
    }

    WfVertex search(int id) {
        return (WfVertex)this.getChildrenGraphModel().resolveVertex(id);
    }

    private Transition getAutoStart(AgentPath agent, State currentState) throws InvalidDataException {
        if (this.getChildrenGraphModel().getStartVertex() != null && !currentState.isFinished() && this.getStateMachine().getInitialStateCode() == this.state) {
            Transition autoStart = null;
            try {
                for (Transition transition : this.getStateMachine().getPossibleTransitions(this, agent).keySet()) {
                    if (transition.isFinishing()) continue;
                    if (autoStart == null) {
                        autoStart = transition;
                        continue;
                    }
                    autoStart = null;
                    break;
                }
                Logger.msg(8, "CompositeActivity.getAutoStart() path:" + this.getPath() + " trans:" + (autoStart == null ? "null" : autoStart.getName()), new Object[0]);
                return autoStart;
            }
            catch (ObjectNotFoundException e) {
                Logger.error((Throwable)((Object)e));
                throw new InvalidDataException("Problem calculating possible transitions for agent " + agent.toString());
            }
        }
        return null;
    }

    @Override
    public void run(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        Logger.msg(8, "CompositeActivity.run() path:" + this.getPath() + " state:" + this.getState(), new Object[0]);
        super.run(agent, itemPath, locker);
        Transition autoStart = this.getAutoStart(agent, this.getStateMachine().getState(this.state));
        if (autoStart != null) {
            try {
                this.request(agent, null, itemPath, autoStart.getId(), null, "", null, locker);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (AccessRightsException e) {
                Logger.warning("Agent:" + agent + " didn't have permission to start the activity:" + this.getPath() + ", so leave it waiting", new Object[0]);
                return;
            }
            catch (Exception e) {
                Logger.error(e);
                throw new InvalidDataException("Problem initializing composite activity: " + e.getMessage());
            }
        }
    }

    @Override
    public void runNext(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        if (!this.isFinished()) {
            Transition trans = null;
            try {
                for (Transition possTran : this.getStateMachine().getPossibleTransitions(this, agent).keySet()) {
                    if (trans == null || trans.isFinishing() && !possTran.isFinishing()) {
                        trans = possTran;
                        continue;
                    }
                    if (trans.isFinishing() != possTran.isFinishing()) continue;
                    Logger.warning("Unclear choice of transition possible from current state for Composite Activity '" + this.getName() + "'. Cannot automatically proceed.", new Object[0]);
                    this.setActive(true);
                    return;
                }
            }
            catch (ObjectNotFoundException e) {
                Logger.error((Throwable)((Object)e));
                throw new InvalidDataException("Problem calculating possible transitions for agent " + agent.toString());
            }
            if (trans == null) {
                Logger.msg(3, "Not possible for the current agent to proceed with the Composite Activity '" + this.getName() + "'.", new Object[0]);
                this.setActive(true);
                return;
            }
            if (trans.hasOutcome(this.getProperties()) || trans.hasScript(this.getProperties())) {
                Logger.msg(3, "Composite activity '" + this.getName() + "' has script or schema defined. Cannot proceed automatically.", new Object[0]);
                this.setActive(true);
                return;
            }
            try {
                this.request(agent, null, itemPath, trans.getId(), null, "", null, locker);
                if (!trans.isFinishing()) {
                    return;
                }
            }
            catch (Exception e) {
                Logger.error(e);
                this.setActive(true);
                throw new InvalidDataException("Problem completing composite activity: " + e.getMessage());
            }
        }
        super.runNext(agent, itemPath, locker);
    }

    @Override
    public ArrayList<Job> calculateJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws InvalidAgentPathException, ObjectNotFoundException, InvalidDataException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        boolean childActive = false;
        if (recurse) {
            for (int i = 0; i < this.getChildren().length; ++i) {
                if (!(this.getChildren()[i] instanceof Activity)) continue;
                Activity child = (Activity)this.getChildren()[i];
                jobs.addAll(child.calculateJobs(agent, itemPath, recurse));
                childActive |= child.active;
            }
        }
        if (!childActive) {
            jobs.addAll(super.calculateJobs(agent, itemPath, recurse));
        }
        return jobs;
    }

    @Override
    public ArrayList<Job> calculateAllJobs(AgentPath agent, ItemPath itemPath, boolean recurse) throws InvalidAgentPathException, ObjectNotFoundException, InvalidDataException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (recurse) {
            for (int i = 0; i < this.getChildren().length; ++i) {
                if (!(this.getChildren()[i] instanceof Activity)) continue;
                Activity child = (Activity)this.getChildren()[i];
                jobs.addAll(child.calculateAllJobs(agent, itemPath, recurse));
            }
        }
        jobs.addAll(super.calculateAllJobs(agent, itemPath, recurse));
        return jobs;
    }

    public Next addNext(WfVertex origin, WfVertex terminus) {
        return new Next(origin, terminus);
    }

    public Next addNext(int originID, int terminusID) {
        return this.addNext(this.search(originID), this.search(terminusID));
    }

    public boolean hasGoodNumberOfActivity() {
        int endingAct = 0;
        for (int i = 0; i < this.getChildren().length; ++i) {
            WfVertex vertex = (WfVertex)this.getChildren()[i];
            if (this.getChildrenGraphModel().getOutEdges(vertex).length != 0) continue;
            ++endingAct;
        }
        return endingAct <= true;
    }

    @Override
    public String getType() {
        return super.getType();
    }

    @Override
    public void reinit(int idLoop) throws InvalidDataException {
        super.reinit(idLoop);
        if (this.getChildrenGraphModel().getStartVertex() != null && !this.getStateMachine().getState(this.state).isFinished()) {
            ((WfVertex)this.getChildrenGraphModel().getStartVertex()).reinit(idLoop);
        }
    }

    @Override
    public void abort() {
        for (GraphableVertex child : this.getChildren()) {
            ((WfVertex)child).abort();
        }
    }

    public boolean hasActive() {
        GraphableVertex[] vChildren = this.getChildren();
        for (int i = 0; i < vChildren.length; ++i) {
            if (!(vChildren[i] instanceof Activity)) continue;
            Activity childAct = (Activity)vChildren[i];
            if (childAct.getActive()) {
                return true;
            }
            if (!(childAct instanceof CompositeActivity) || !((CompositeActivity)vChildren[i]).hasActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String request(AgentPath agent, AgentPath delegator, ItemPath itemPath, int transitionID, String requestData, String attachmentType, byte[] attachment, Object locker) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        Transition trans = this.getStateMachine().getTransition(transitionID);
        if (trans.isFinishing() && this.hasActive()) {
            if (((Boolean)this.getBuiltInProperty(BuiltInVertexProperties.ABORTABLE)).booleanValue()) {
                this.abort();
            } else {
                throw new InvalidTransitionException("Attempted to finish '" + this.getPath() + "' it had active children but was not Abortable");
            }
        }
        if (this.getStateMachine().getTransition(transitionID).reinitializes()) {
            int preserveState = this.state;
            this.reinit(this.getID());
            this.setState(preserveState);
        }
        if (this.getChildrenGraphModel().getStartVertex() != null && (this.getStateMachine().getState(this.state).equals(this.getStateMachine().getInitialState()) || this.getStateMachine().getTransition(transitionID).reinitializes())) {
            ((WfVertex)this.getChildrenGraphModel().getStartVertex()).run(agent, itemPath, locker);
        }
        return super.request(agent, delegator, itemPath, transitionID, requestData, attachmentType, attachment, locker);
    }

    public void refreshJobs(ItemPath itemPath) {
        GraphableVertex[] children;
        for (GraphableVertex element : children = this.getChildren()) {
            if (element instanceof CompositeActivity) {
                ((CompositeActivity)element).refreshJobs(itemPath);
                continue;
            }
            if (!(element instanceof Activity)) continue;
            ((Activity)element).pushJobsToAgents(itemPath);
        }
    }

    public List<Activity> getPossibleActs(WfVertex fromVertex, int direction) throws InvalidDataException {
        ArrayList<Activity> nextActs = new ArrayList<Activity>();
        for (Vertex v : GraphTraversal.getTraversal(this.getChildrenGraphModel(), fromVertex, direction, false)) {
            Activity act;
            if (!(v instanceof Activity) || (act = (Activity)v).isFinished() || !act.active) continue;
            nextActs.add(act);
        }
        return nextActs;
    }
}

