/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.Logger;

public class ChangeName
extends PredefinedStep {
    public static final String description = "Removes Items old Name, add the new Name and changes the Name property";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectCannotBeUpdated, ObjectAlreadyExistsException, CannotManageException {
        Object[] params = ChangeName.getDataList(requestData);
        if (params.length != 2) {
            throw new InvalidDataException("ChangeName: Invalid parameters: " + Arrays.toString(params));
        }
        String oldName = params[0];
        String newName = params[1];
        Logger.msg(3, "ChangeName - oldName:%s newName:%s", oldName, newName);
        if (oldName.equals(newName)) {
            Logger.msg(3, "ChangeName - oldName:%s == newName:%s - NOTHING DONE", oldName, newName);
            return requestData;
        }
        Lookup.PagedResult result = Gateway.getLookup().searchAliases(item, 0, 100);
        DomainPath currentDP = null;
        if (result.rows.size() > 0) {
            for (Path path : result.rows) {
                if (!path.getName().equals(oldName)) continue;
                currentDP = (DomainPath)path;
                break;
            }
            if (currentDP == null) {
                throw new InvalidDataException(item + " does not domainPath with name:" + oldName);
            }
        } else {
            throw new InvalidDataException(item + " does not have any domainPath");
        }
        DomainPath rootDP = currentDP.getParent();
        DomainPath newDP = new DomainPath(rootDP, newName);
        newDP.setItemPath(item);
        Gateway.getLookupManager().add(newDP);
        try {
            Gateway.getLookupManager().delete(currentDP);
        }
        catch (Exception e) {
            Logger.error(e);
            Gateway.getLookupManager().delete(newDP);
            throw new CannotManageException(e.getMessage());
        }
        try {
            PropertyUtility.writeProperty(item, "Name", newName, locker);
        }
        catch (Exception e) {
            Logger.error(e);
            Gateway.getLookupManager().delete(newDP);
            Gateway.getLookupManager().add(currentDP);
            throw new CannotManageException(e.getMessage());
        }
        return requestData;
    }
}

