/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.Logger;

public class AddNewSlot
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        String collName;
        ItemPath descKey = null;
        Object descVer = "last";
        Object[] params = AddNewSlot.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "AddNewSlot: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params), new Object[0]);
        }
        try {
            collName = params[0];
            if (params.length > 1 && params[1].length() > 0) {
                try {
                    descKey = new ItemPath((String)params[1]);
                }
                catch (InvalidItemPathException e) {
                    descKey = new DomainPath((String)params[1]).getItemPath();
                }
            }
            if (params.length > 2 && ((String)params[2]).length() > 0) {
                descVer = params[2];
            }
        }
        catch (Exception e) {
            throw new InvalidDataException("AddNewSlot: Invalid parameters " + Arrays.toString(params));
        }
        C2KLocalObject collObj = Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/last", locker);
        if (!(collObj instanceof Aggregation)) {
            throw new InvalidDataException("AddNewSlot operates on Aggregation only.");
        }
        Aggregation agg = (Aggregation)collObj;
        CastorHashMap props = new CastorHashMap();
        StringBuffer classProps = new StringBuffer();
        if (descKey != null) {
            PropertyDescriptionList propList = PropertyUtility.getPropertyDescriptionOutcome(descKey, (String)descVer, locker);
            for (PropertyDescription pd : propList.list) {
                props.put(pd.getName(), pd.getDefaultValue());
                if (!pd.getIsClassIdentifier()) continue;
                classProps.append(classProps.length() > 0 ? "," : "").append(pd.getName());
            }
        }
        agg.addSlot(props, classProps.toString());
        Gateway.getStorage().put(item, agg, locker);
        return requestData;
    }
}

