/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionalClusterStorage;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.SoftCache;
import org.cristalise.kernel.utils.WeakCache;

public class ClusterStorageManager {
    HashMap<String, ClusterStorage> allStores = new HashMap();
    String[] clusterPriority = new String[0];
    HashMap<ClusterType, ArrayList<ClusterStorage>> clusterWriters = new HashMap();
    HashMap<ClusterType, ArrayList<ClusterStorage>> clusterReaders = new HashMap();
    ArrayList<TransactionalClusterStorage> transactionalStores = new ArrayList();
    HashMap<ItemPath, Map<String, C2KLocalObject>> memoryCache = new HashMap();
    Map<Object, Set<ProxyMessage>> proxyMessagesMap = new ConcurrentHashMap<Object, Set<ProxyMessage>>();

    public ClusterStorageManager(Authenticator auth) throws PersistencyException {
        ArrayList<ClusterStorage> rootStores;
        Object clusterStorageProp = Gateway.getProperties().getObject("ClusterStorage");
        if (clusterStorageProp == null || "".equals(clusterStorageProp)) {
            throw new PersistencyException("ClusterStorageManager.init() - no ClusterStorages defined. No persistency!");
        }
        if (clusterStorageProp instanceof String) {
            rootStores = this.instantiateStores((String)clusterStorageProp);
        } else if (clusterStorageProp instanceof ArrayList) {
            ArrayList propStores = (ArrayList)clusterStorageProp;
            rootStores = new ArrayList();
            this.clusterPriority = new String[propStores.size()];
            for (ClusterStorage thisStore : propStores) {
                if (thisStore instanceof ClusterStorage) {
                    rootStores.add(thisStore);
                    continue;
                }
                throw new PersistencyException("Supplied ClusterStorage " + thisStore.toString() + " was not an instance of ClusterStorage");
            }
        } else {
            throw new PersistencyException("Unknown class of ClusterStorage property: " + clusterStorageProp.getClass().getName());
        }
        int clusterNo = 0;
        for (ClusterStorage newStorage : rootStores) {
            try {
                newStorage.open(auth);
            }
            catch (PersistencyException ex) {
                Logger.error((Throwable)((Object)ex));
                throw new PersistencyException("ClusterStorageManager.init() - Error initialising storage handler " + newStorage.getClass().getName() + ": " + ex.getMessage());
            }
            Logger.msg(5, "ClusterStorageManager.init() - Cluster storage " + newStorage.getClass().getName() + " initialised successfully.", new Object[0]);
            this.allStores.put(newStorage.getId(), newStorage);
            this.clusterPriority[clusterNo++] = newStorage.getId();
            if (!(newStorage instanceof TransactionalClusterStorage)) continue;
            this.transactionalStores.add((TransactionalClusterStorage)newStorage);
        }
        this.clusterReaders.put(ClusterType.ROOT, rootStores);
    }

    public ArrayList<ClusterStorage> instantiateStores(String allClusters) throws PersistencyException {
        ArrayList<ClusterStorage> rootStores = new ArrayList<ClusterStorage>();
        StringTokenizer tok = new StringTokenizer(allClusters, ",");
        this.clusterPriority = new String[tok.countTokens()];
        while (tok.hasMoreTokens()) {
            ClusterStorage newStorage = null;
            String newStorageClass = tok.nextToken();
            try {
                if (!newStorageClass.contains(".")) {
                    newStorageClass = "org.cristalise.storage." + newStorageClass;
                }
                newStorage = (ClusterStorage)Class.forName(newStorageClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new PersistencyException("ClusterStorageManager.init() - The cluster storage handler class " + newStorageClass + " could not be found.");
            }
            rootStores.add(newStorage);
        }
        return rootStores;
    }

    public void close() {
        for (ClusterStorage thisStorage : this.allStores.values()) {
            try {
                thisStorage.close();
            }
            catch (PersistencyException ex) {
                Logger.error((Throwable)((Object)ex));
            }
        }
    }

    private ClusterStorage findStorageForQuery(String language) {
        for (String element : this.clusterPriority) {
            ClusterStorage store = this.allStores.get(element);
            if (!store.checkQuerySupport(language)) continue;
            return store;
        }
        return null;
    }

    private ArrayList<ClusterStorage> findStorages(ClusterType clusterType, boolean forWrite) {
        HashMap<ClusterType, ArrayList<ClusterStorage>> cache = forWrite ? this.clusterWriters : this.clusterReaders;
        if (cache.containsKey((Object)clusterType)) {
            return cache.get((Object)clusterType);
        }
        Logger.msg(7, "ClusterStorageManager.findStorages() - finding storage for " + (Object)((Object)clusterType) + " forWrite:" + forWrite, new Object[0]);
        ArrayList<ClusterStorage> useableStorages = new ArrayList<ClusterStorage>();
        for (String element : this.clusterPriority) {
            int requiredSupport;
            ClusterStorage thisStorage = this.allStores.get(element);
            int n = requiredSupport = forWrite ? 2 : 1;
            if ((thisStorage.queryClusterSupport(clusterType) & requiredSupport) != requiredSupport) continue;
            Logger.msg(7, "ClusterStorageManager.findStorages() - Got " + thisStorage.getName(), new Object[0]);
            useableStorages.add(thisStorage);
        }
        cache.put(clusterType, useableStorages);
        return useableStorages;
    }

    public String executeQuery(Query query) throws PersistencyException {
        ClusterStorage reader = this.findStorageForQuery(query.getLanguage());
        if (reader != null) {
            return reader.executeQuery(query);
        }
        throw new PersistencyException("No storage was found supporting language:" + query.getLanguage() + " query:" + query.getName());
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        ArrayList<String> contents = new ArrayList<String>();
        Logger.msg(8, "ClusterStorageManager.getClusterContents() - path:" + path, new Object[0]);
        ArrayList<ClusterStorage> readers = this.findStorages(ClusterStorage.getClusterType(path), false);
        for (ClusterStorage thisReader : readers) {
            try {
                String[] thisArr = thisReader.getClusterContents(itemPath, path);
                if (thisArr == null) continue;
                for (int j = 0; j < thisArr.length; ++j) {
                    if (contents.contains(thisArr[j])) continue;
                    Logger.msg(9, "ClusterStorageManager.getClusterContents() - " + thisReader.getName() + " reports " + thisArr[j], new Object[0]);
                    contents.add(thisArr[j]);
                }
            }
            catch (PersistencyException e) {
                Logger.msg(5, "ClusterStorageManager.getClusterContents() - reader " + thisReader.getName() + " could not retrieve contents of " + itemPath + "/" + path + ": " + e.getMessage(), new Object[0]);
            }
        }
        Logger.msg(8, "ClusterStorageManager.getClusterContents() - Returning " + contents.size() + " elements of path:" + path, new Object[0]);
        String[] retArr = new String[]{};
        retArr = contents.toArray(retArr);
        return retArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException, ObjectNotFoundException {
        StringTokenizer tok;
        Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(itemPath);
        if (sysKeyMemCache != null) {
            Map<String, C2KLocalObject> map = sysKeyMemCache;
            synchronized (map) {
                C2KLocalObject obj = sysKeyMemCache.get(path);
                if (obj != null) {
                    Logger.msg(7, "ClusterStorageManager.get() - found " + itemPath + "/" + path + " in memcache", new Object[0]);
                    return obj;
                }
            }
        }
        if (path.startsWith(ClusterType.VIEWPOINT.getName()) && path.endsWith("/data") && (tok = new StringTokenizer(path, "/")).countTokens() == 4) {
            Viewpoint view = (Viewpoint)this.get(itemPath, path.substring(0, path.lastIndexOf("/")));
            if (view != null) {
                return view.getOutcome();
            }
            return null;
        }
        C2KLocalObject result = null;
        if (path.indexOf(47) == -1) {
            if (path.equals(ClusterType.HISTORY.getName())) {
                result = new History(itemPath, null);
            } else if (path.equals(ClusterType.JOB.getName())) {
                if (itemPath instanceof AgentPath) {
                    result = new JobList((AgentPath)itemPath, null);
                } else {
                    throw new ObjectNotFoundException("Items do not have job lists");
                }
            }
        }
        if (result == null) {
            ArrayList<ClusterStorage> readers = this.findStorages(ClusterStorage.getClusterType(path), false);
            for (ClusterStorage thisReader : readers) {
                try {
                    result = thisReader.get(itemPath, path);
                    Logger.msg(7, "ClusterStorageManager.get() - reading " + path + " from " + thisReader.getName() + " for item " + itemPath, new Object[0]);
                    if (result == null) continue;
                    break;
                }
                catch (PersistencyException e) {
                    Logger.msg(7, "ClusterStorageManager.get() - reader " + thisReader.getName() + " could not retrieve " + itemPath + "/" + path + ": " + e.getMessage(), new Object[0]);
                }
            }
        }
        if (result == null) {
            throw new ObjectNotFoundException("ClusterStorageManager.get() - Path " + path + " not found in " + itemPath);
        }
        this.putInMemoryCache(itemPath, path, result);
        return result;
    }

    public void put(ItemPath itemPath, C2KLocalObject obj) throws PersistencyException {
        this.put(itemPath, obj, null);
    }

    public void put(ItemPath itemPath, C2KLocalObject obj, Object locker) throws PersistencyException {
        String path = ClusterStorage.getPath(obj);
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(path), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                Logger.msg(7, "ClusterStorageManager.put() - writing " + path + " to " + thisWriter.getName(), new Object[0]);
                if (thisWriter instanceof TransactionalClusterStorage && locker != null) {
                    ((TransactionalClusterStorage)thisWriter).put(itemPath, obj, locker);
                    continue;
                }
                thisWriter.put(itemPath, obj);
            }
            catch (PersistencyException e) {
                Logger.error("ClusterStorageManager.put() - writer " + thisWriter.getName() + " could not store " + itemPath + "/" + path + ": " + e.getMessage(), new Object[0]);
                throw e;
            }
        }
        this.putInMemoryCache(itemPath, path, obj);
        ProxyMessage message = new ProxyMessage(itemPath, path, false);
        if (locker != null) {
            this.keepMessageForLater(message, locker);
        } else {
            this.sendProxyEvent(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInMemoryCache(ItemPath itemPath, String path, C2KLocalObject obj) {
        Map<String, C2KLocalObject> sysKeyMemCache;
        if (Gateway.getProperties().getBoolean("Storage.disableCache", false)) {
            Logger.msg(8, "ClusterStorageManager.putInMemoryCache() - Cache is DISABLED", new Object[0]);
            return;
        }
        if (this.memoryCache.containsKey(itemPath)) {
            sysKeyMemCache = this.memoryCache.get(itemPath);
        } else {
            boolean useWeak = Gateway.getProperties().getBoolean("Storage.useWeakCache", false);
            Logger.msg(7, "ClusterStorageManager.putInMemoryCache() - Creating " + (useWeak ? "Weak" : "Strong") + " cache for item " + itemPath, new Object[0]);
            sysKeyMemCache = useWeak ? new WeakCache() : new SoftCache(0);
            HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
            synchronized (hashMap) {
                this.memoryCache.put(itemPath, sysKeyMemCache);
            }
        }
        Map<String, C2KLocalObject> map = sysKeyMemCache;
        synchronized (map) {
            sysKeyMemCache.put(path, obj);
        }
        if (Logger.doLog(9)) {
            this.dumpCacheContents(9);
        }
    }

    public void remove(ItemPath itemPath, String path) throws PersistencyException {
        this.remove(itemPath, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(path), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                Logger.msg(7, "ClusterStorageManager.delete() - removing " + path + " from " + thisWriter.getName(), new Object[0]);
                if (thisWriter instanceof TransactionalClusterStorage && locker != null) {
                    ((TransactionalClusterStorage)thisWriter).delete(itemPath, path, locker);
                    continue;
                }
                thisWriter.delete(itemPath, path);
            }
            catch (PersistencyException e) {
                Logger.error("ClusterStorageManager.delete() - writer " + thisWriter.getName() + " could not delete " + itemPath + "/" + path + ": " + e.getMessage(), new Object[0]);
                throw e;
            }
        }
        if (this.memoryCache.containsKey(itemPath)) {
            Map<String, C2KLocalObject> itemMemCache;
            Map<String, C2KLocalObject> map = itemMemCache = this.memoryCache.get(itemPath);
            synchronized (map) {
                itemMemCache.remove(path);
            }
        }
        ProxyMessage message = new ProxyMessage(itemPath, path, true);
        if (locker != null) {
            this.keepMessageForLater(message, locker);
        } else {
            this.sendProxyEvent(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ItemPath itemPath, String path) {
        Logger.msg(7, "ClusterStorageManager.clearCache() - removing " + itemPath + "/" + path, new Object[0]);
        if (this.memoryCache.containsKey(itemPath)) {
            Map<String, C2KLocalObject> sysKeyMemCache;
            Map<String, C2KLocalObject> map = sysKeyMemCache = this.memoryCache.get(itemPath);
            synchronized (map) {
                Iterator<String> iter = sysKeyMemCache.keySet().iterator();
                while (iter.hasNext()) {
                    String thisPath = iter.next();
                    if (!thisPath.startsWith(path)) continue;
                    Logger.msg(7, "ClusterStorageManager.clearCache() - removing " + itemPath + "/" + thisPath, new Object[0]);
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ItemPath itemPath) {
        Logger.msg(5, "ClusterStorageManager.clearCache() - removing entire cache of " + itemPath, new Object[0]);
        if (this.memoryCache.containsKey(itemPath)) {
            HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
            synchronized (hashMap) {
                if (Logger.doLog(6)) {
                    Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(itemPath);
                    int size = sysKeyMemCache.size();
                    Logger.msg(6, "ClusterStorageManager.clearCache() - " + size + " objects to remove.", new Object[0]);
                }
                this.memoryCache.remove(itemPath);
            }
        } else {
            Logger.msg(6, "ClusterStorageManager.clearCache() - No objects cached", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
        synchronized (hashMap) {
            this.memoryCache.clear();
        }
        Logger.msg(5, "ClusterStorageManager.clearCache() - cleared entire cache, " + this.memoryCache.size() + " entities.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCacheContents(int logLevel) {
        if (!Logger.doLog(logLevel)) {
            return;
        }
        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
        synchronized (hashMap) {
            for (ItemPath itemPath : this.memoryCache.keySet()) {
                Logger.msg(logLevel, "Cached Objects of Item " + itemPath, new Object[0]);
                Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(itemPath);
                try {
                    Map<String, C2KLocalObject> map = sysKeyMemCache;
                    synchronized (map) {
                        Iterator<String> iterator = sysKeyMemCache.keySet().iterator();
                        while (iterator.hasNext()) {
                            String name;
                            String path = name = iterator.next();
                            try {
                                Logger.msg(logLevel, "    Path " + path + ": " + sysKeyMemCache.get(path).getClass().getName(), new Object[0]);
                            }
                            catch (NullPointerException e) {
                                Logger.msg(logLevel, "    Path " + path + ": reaped", new Object[0]);
                            }
                        }
                    }
                }
                catch (ConcurrentModificationException ex) {
                    Logger.msg(logLevel, "Cache modified - aborting", new Object[0]);
                }
            }
            Logger.msg(logLevel, "Total number of cached entities: " + this.memoryCache.size(), new Object[0]);
        }
    }

    public void begin(Object locker) throws PersistencyException {
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.begin(locker);
        }
    }

    public void commit(Object locker) throws PersistencyException {
        Set<ProxyMessage> messageSet = null;
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.commit(locker);
        }
        if (locker != null && (messageSet = this.proxyMessagesMap.remove(locker)) != null) {
            for (ProxyMessage message : messageSet) {
                Gateway.getProxyServer().sendProxyEvent(message);
            }
        }
    }

    public void abort(Object locker) throws PersistencyException {
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.abort(locker);
        }
        if (locker != null) {
            this.proxyMessagesMap.remove(locker);
        }
    }

    public void postConnect() throws PersistencyException {
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.postConnect();
        }
    }

    public void postBoostrap() throws PersistencyException {
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.postBoostrap();
        }
    }

    public void postStartServer() throws PersistencyException {
        for (TransactionalClusterStorage thisStore : this.transactionalStores) {
            thisStore.postStartServer();
        }
    }

    private void keepMessageForLater(ProxyMessage message, Object locker) {
        Set<ProxyMessage> set = this.proxyMessagesMap.get(locker);
        if (set == null) {
            set = new HashSet<ProxyMessage>();
            this.proxyMessagesMap.put(locker, set);
        }
        set.add(message);
    }

    private void sendProxyEvent(ProxyMessage message) {
        if (Gateway.getProxyServer() != null) {
            Gateway.getProxyServer().sendProxyEvent(message);
        } else {
            Logger.warning("ClusterStorageManager.sendProxyEvent: ProxyServer is null - Proxies are not notified of this event", new Object[0]);
        }
    }
}

