/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity;

import java.util.Map;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.AgentHelper;
import org.cristalise.kernel.entity.ItemHelper;
import org.cristalise.kernel.entity.TraceableEntity;
import org.cristalise.kernel.entity.TraceableLocator;
import org.cristalise.kernel.entity.agent.ActiveEntity;
import org.cristalise.kernel.entity.agent.ActiveLocator;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.SoftCache;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class CorbaServer {
    private final Map<ItemPath, Servant> mItemCache = new SoftCache<ItemPath, Servant>(50);
    private POA mRootPOA;
    private POA mItemPOA;
    private POA mAgentPOA;
    private POAManager mPOAManager;

    public CorbaServer() throws CannotManageException {
        try {
            this.setupPOA();
            this.mPOAManager.activate();
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new CannotManageException("Error initialising POA");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("ORB Invoker");
                Gateway.getORB().run();
            }
        }).start();
    }

    public void close() {
        try {
            this.mPOAManager.deactivate(true, true);
            this.mRootPOA.destroy(true, true);
        }
        catch (AdapterInactive ex) {
            Logger.error(ex);
        }
    }

    private void setupPOA() throws Exception {
        this.mRootPOA = POAHelper.narrow((Object)Gateway.getORB().resolve_initial_references("RootPOA"));
        this.mPOAManager = this.mRootPOA.the_POAManager();
        Policy[] policies = new Policy[]{this.mRootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.mRootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), this.mRootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.mRootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID), this.mRootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER), this.mRootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION)};
        this.mItemPOA = this.mRootPOA.create_POA("Item", this.mRootPOA.the_POAManager(), policies);
        this.mAgentPOA = this.mRootPOA.create_POA("Agent", this.mRootPOA.the_POAManager(), policies);
        TraceableLocator itemLocator = new TraceableLocator();
        this.mItemPOA.set_servant_manager((ServantManager)itemLocator._this(Gateway.getORB()));
        ActiveLocator agentLocator = new ActiveLocator();
        this.mAgentPOA.set_servant_manager((ServantManager)agentLocator._this(Gateway.getORB()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceableEntity getItem(ItemPath itemPath) throws ObjectNotFoundException {
        java.lang.Object item = null;
        if (!itemPath.exists()) {
            throw new ObjectNotFoundException(itemPath + " does not exist");
        }
        Map<ItemPath, Servant> map = this.mItemCache;
        synchronized (map) {
            item = this.mItemCache.get(itemPath);
            if (item == null) {
                Logger.msg(7, "Creating new servant for " + itemPath, new java.lang.Object[0]);
                item = new TraceableEntity(itemPath, this.mItemPOA);
                this.mItemCache.put(itemPath, (Servant)item);
            }
        }
        return (TraceableEntity)((java.lang.Object)item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveEntity getAgent(AgentPath agentPath) throws InvalidAgentPathException, ObjectNotFoundException {
        java.lang.Object agent = null;
        if (!agentPath.exists()) {
            throw new ObjectNotFoundException(agentPath + " does not exist");
        }
        Map<ItemPath, Servant> map = this.mItemCache;
        synchronized (map) {
            agent = this.mItemCache.get(agentPath);
            if (agent == null) {
                Logger.msg(7, "Creating new servant for " + agentPath, new java.lang.Object[0]);
                agent = new ActiveEntity(agentPath, this.mAgentPOA);
                this.mItemCache.put(agentPath, (Servant)agent);
            } else if (!(agent instanceof ActiveEntity)) {
                throw new InvalidAgentPathException("Item " + agentPath + " was not an agent");
            }
        }
        return (ActiveEntity)((java.lang.Object)agent);
    }

    public Object getItemIOR(ItemPath itemPath) {
        return this.mItemPOA.create_reference_with_id(itemPath.getOID(), ItemHelper.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceableEntity createItem(ItemPath itemPath) throws CannotManageException, ObjectAlreadyExistsException {
        if (itemPath.exists()) {
            throw new ObjectAlreadyExistsException();
        }
        itemPath.setIOR(this.getItemIOR(itemPath));
        TraceableEntity item = new TraceableEntity(itemPath, this.mItemPOA);
        Map<ItemPath, Servant> map = this.mItemCache;
        synchronized (map) {
            this.mItemCache.put(itemPath, (Servant)item);
        }
        return item;
    }

    public Object getAgentIOR(AgentPath agentPath) {
        return this.mAgentPOA.create_reference_with_id(agentPath.getOID(), AgentHelper.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveEntity createAgent(AgentPath agentPath) throws CannotManageException, ObjectAlreadyExistsException {
        if (agentPath.exists()) {
            throw new ObjectAlreadyExistsException("Agent:" + agentPath.getAgentName());
        }
        agentPath.setIOR(this.getAgentIOR(agentPath));
        ActiveEntity agent = new ActiveEntity(agentPath, this.mAgentPOA);
        Map<ItemPath, Servant> map = this.mItemCache;
        synchronized (map) {
            this.mItemCache.put(agentPath, (Servant)agent);
        }
        return agent;
    }
}

