/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationDescription;
import org.cristalise.kernel.collection.AggregationInstance;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportAggregationMember;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;

public class ImportAggregation {
    public String name;
    public Integer version;
    public boolean isDescription;
    public ArrayList<ImportAggregationMember> aggregationMemberList = new ArrayList();

    public ImportAggregation() {
    }

    public ImportAggregation(String name, boolean isDescription) {
        this();
        this.name = name;
        this.isDescription = isDescription;
    }

    public Aggregation create() throws InvalidCollectionModification, ObjectNotFoundException, ObjectAlreadyExistsException {
        Aggregation newAgg;
        Aggregation aggregation = newAgg = this.isDescription ? new AggregationDescription(this.name) : new AggregationInstance(this.name);
        if (this.version != null) {
            newAgg.setVersion(this.version);
        }
        for (ImportAggregationMember thisMem : this.aggregationMemberList) {
            StringBuffer classProps = new StringBuffer();
            ItemPath itemPath = null;
            if (thisMem.itemDescriptionPath != null && thisMem.itemDescriptionPath.length() > 0) {
                try {
                    itemPath = new ItemPath(thisMem.itemDescriptionPath);
                }
                catch (InvalidItemPathException ex) {
                    itemPath = new DomainPath(thisMem.itemDescriptionPath).getItemPath();
                }
                String descVer = thisMem.itemDescriptionVersion == null ? "last" : thisMem.itemDescriptionVersion;
                PropertyDescriptionList propList = PropertyUtility.getPropertyDescriptionOutcome(itemPath, descVer, null);
                for (PropertyDescription pd : propList.list) {
                    thisMem.props.put(pd.getName(), pd.getDefaultValue());
                    if (!pd.getIsClassIdentifier()) continue;
                    classProps.append(classProps.length() > 0 ? "," : "").append(pd.getName());
                }
            }
            if (thisMem.itemPath != null && thisMem.itemPath.length() > 0) {
                try {
                    itemPath = new ItemPath(thisMem.itemPath);
                }
                catch (InvalidItemPathException ex) {
                    itemPath = new DomainPath(thisMem.itemPath).getItemPath();
                }
            }
            newAgg.addMember(itemPath, thisMem.props, classProps.toString(), new GraphPoint(thisMem.geometry.x, thisMem.geometry.y), thisMem.geometry.width, thisMem.geometry.height);
        }
        return newAgg;
    }
}

