/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.utils.Logger;

public class MemberSubscription<C extends C2KLocalObject>
implements Runnable {
    public static final String ERROR = "Error";
    public static final String END = "theEND";
    ItemProxy subject;
    String interest;
    WeakReference<ProxyObserver<C>> observerReference;
    ArrayList<String> contents = new ArrayList();
    boolean preLoad;

    public MemberSubscription(ProxyObserver<C> observer, String interest, boolean preLoad) {
        this.setObserver(observer);
        this.interest = interest;
        this.preLoad = preLoad;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("MemberSubscription:" + this.subject.getPath() + ":" + this.interest);
        if (this.preLoad) {
            this.loadChildren();
        }
    }

    private void loadChildren() {
        ProxyObserver<C> observer = this.getObserver();
        if (observer == null) {
            return;
        }
        try {
            String children = this.subject.queryData(this.interest + "/all");
            StringTokenizer tok = new StringTokenizer(children, ",");
            ArrayList<String> newContents = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                newContents.add(tok.nextToken());
            }
            for (String newChild : newContents) {
                try {
                    C2KLocalObject newMember = this.subject.getObject(this.interest + "/" + newChild);
                    this.contents.remove(newChild);
                    observer.add(newMember);
                }
                catch (ObjectNotFoundException ex) {
                    observer.control(ERROR, "Listed member " + newChild + " was not found.");
                }
                catch (ClassCastException ex) {
                    Logger.error(ex);
                    observer.control(ERROR, "Listed member " + newChild + " was the wrong type.");
                }
            }
            for (String oldChild : this.contents) {
                observer.remove(this.interest + "/" + oldChild);
            }
            this.contents = newContents;
            observer.control(END, null);
        }
        catch (Exception ex) {
            observer.control(ERROR, "Query on " + this.interest + " failed with " + ex.getMessage());
        }
        Logger.msg(5, "MemberSubscription.loadChildren() -  DONE interest:" + this.interest, new Object[0]);
    }

    public boolean isRelevant(String path) {
        Logger.msg(7, "MemberSubscription.isRelevant() - path " + path + " to " + this.interest, new Object[0]);
        return path.startsWith(this.interest);
    }

    public void update(String path, boolean deleted) {
        ProxyObserver<C> observer = this.getObserver();
        if (observer == null) {
            return;
        }
        Logger.msg(7, "MemberSubscription.update() - path " + path + " for " + observer + ". Interest: " + this.interest + " Was Deleted:" + deleted, new Object[0]);
        if (!path.startsWith(this.interest)) {
            return;
        }
        if (path.equals(this.interest)) {
            this.loadChildren();
        } else {
            String name = path.substring(this.interest.length() + 1);
            if (deleted) {
                Logger.msg(7, "MemberSubscription.update() - Removing path:" + path + " name:" + name, new Object[0]);
                this.contents.remove(name);
                observer.remove(name);
            } else {
                try {
                    C2KLocalObject newMember = this.subject.getObject(path);
                    Logger.msg(7, "MemberSubscription.update() - Adding path:" + path + " name:" + name, new Object[0]);
                    this.contents.add(name);
                    observer.add(newMember);
                }
                catch (ObjectNotFoundException e) {
                    Logger.error("MemberSubscription could not load path:" + path, new Object[0]);
                    Logger.error(e);
                }
            }
        }
    }

    public void setObserver(ProxyObserver<C> observer) {
        this.observerReference = new WeakReference<ProxyObserver<C>>(observer);
    }

    public void setSubject(ItemProxy subject) {
        this.subject = subject;
    }

    public ProxyObserver<C> getObserver() {
        return (ProxyObserver)this.observerReference.get();
    }
}

