/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.model;

import java.awt.Polygon;
import java.util.Vector;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;

public class Vertex {
    private int mID = -1;
    private String mName = "";
    private GraphPoint mCentrePoint = new GraphPoint(0, 0);
    private int mHeight = 0;
    private int mWidth = 0;
    private Vector<Integer> mInEdgeIdVector = new Vector();
    private Vector<Integer> mOutEdgeIdVector = new Vector();
    private final Vector<Object> mTags = new Vector();
    private Polygon mOutlinePolygon = new Polygon();
    private GraphPoint[] mOutlinePoints = new GraphPoint[0];

    public void setOutlinePoints(GraphPoint[] outline) {
        int topLeftX = outline[0].x;
        int topLeftY = outline[0].y;
        int bottomRightX = 0;
        int bottomRightY = 0;
        this.mOutlinePoints = outline;
        this.mOutlinePolygon = new Polygon();
        for (int i = 0; i < outline.length; ++i) {
            this.mOutlinePolygon.addPoint(outline[i].x, outline[i].y);
            if (outline[i].x < topLeftX) {
                topLeftX = outline[i].x;
            }
            if (outline[i].y < topLeftY) {
                topLeftY = outline[i].y;
            }
            if (outline[i].x > bottomRightX) {
                bottomRightX = outline[i].x;
            }
            if (outline[i].y <= bottomRightY) continue;
            bottomRightY = outline[i].y;
        }
        this.mHeight = bottomRightY - topLeftY;
        this.mWidth = bottomRightX - topLeftX;
    }

    public void moveAbsolute(GraphPoint p) {
        int deltaX = p.x - this.mCentrePoint.x;
        int deltaY = p.y - this.mCentrePoint.y;
        int i = 0;
        for (i = 0; i < this.mOutlinePoints.length; ++i) {
            this.mOutlinePoints[i].x += deltaX;
            this.mOutlinePoints[i].y += deltaY;
        }
        this.mOutlinePolygon.translate(deltaX, deltaY);
        this.mCentrePoint.x = p.x;
        this.mCentrePoint.y = p.y;
    }

    public boolean containsPoint(GraphPoint p) {
        return this.mOutlinePolygon.contains(p.x, p.y);
    }

    public void setInEdgeIds(int[] ids) {
        this.mInEdgeIdVector = new Vector(10, 10);
        for (int i = 0; i < ids.length; ++i) {
            this.mInEdgeIdVector.add(ids[i]);
        }
    }

    public int[] getInEdgeIds() {
        return Vertex.integerVectorToIntArray(this.mInEdgeIdVector);
    }

    public void setOutEdgeIds(int[] ids) {
        this.mOutEdgeIdVector = new Vector(10, 10);
        for (int i = 0; i < ids.length; ++i) {
            this.mOutEdgeIdVector.add(ids[i]);
        }
    }

    public int[] getOutEdgeIds() {
        return Vertex.integerVectorToIntArray(this.mOutEdgeIdVector);
    }

    private static int[] integerVectorToIntArray(Vector<Integer> vector) {
        int[] array = new int[vector.size()];
        Integer integer = null;
        for (int i = 0; i < array.length; ++i) {
            integer = vector.elementAt(i);
            array[i] = integer;
        }
        return array;
    }

    public void addInEdgeId(int id) {
        this.mInEdgeIdVector.add(id);
    }

    public void removeInEdgeId(int id) {
        Integer integer = null;
        for (int i = 0; i < this.mInEdgeIdVector.size(); ++i) {
            integer = this.mInEdgeIdVector.elementAt(i);
            if (integer != id) continue;
            this.mInEdgeIdVector.removeElementAt(i);
            return;
        }
    }

    public void addOutEdgeId(int id) {
        this.mOutEdgeIdVector.add(id);
    }

    public void removeOutEdgeId(int id) {
        Integer integer = null;
        for (int i = 0; i < this.mOutEdgeIdVector.size(); ++i) {
            integer = this.mOutEdgeIdVector.elementAt(i);
            if (integer != id) continue;
            this.mOutEdgeIdVector.removeElementAt(i);
            return;
        }
    }

    public void setTag(Object o) {
        this.mTags.add(o);
    }

    public boolean hasTag(Object o) {
        return this.mTags.contains(o);
    }

    public void clearTag(Object o) {
        this.mTags.remove(o);
    }

    public GraphModel getChildrenGraphModel() {
        return null;
    }

    public Object getCreationContext() {
        return null;
    }

    public boolean isJoin() {
        return false;
    }

    public boolean isLoop() {
        return false;
    }

    public int getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public GraphPoint getCentrePoint() {
        return this.mCentrePoint;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public Vector<Integer> getInEdgeIdVector() {
        return this.mInEdgeIdVector;
    }

    public Vector<Integer> getOutEdgeIdVector() {
        return this.mOutEdgeIdVector;
    }

    public Vector<Object> getTags() {
        return this.mTags;
    }

    public Polygon getOutlinePolygon() {
        return this.mOutlinePolygon;
    }

    public GraphPoint[] getOutlinePoints() {
        return this.mOutlinePoints;
    }

    public void setID(int mID) {
        this.mID = mID;
    }

    public void setName(String mName) {
        this.mName = mName;
    }

    public void setCentrePoint(GraphPoint mCentrePoint) {
        this.mCentrePoint = mCentrePoint;
    }

    public void setHeight(int mHeight) {
        this.mHeight = mHeight;
    }

    public void setWidth(int mWidth) {
        this.mWidth = mWidth;
    }

    public void setInEdgeIdVector(Vector<Integer> mInEdgeIdVector) {
        this.mInEdgeIdVector = mInEdgeIdVector;
    }

    public void setOutEdgeIdVector(Vector<Integer> mOutEdgeIdVector) {
        this.mOutEdgeIdVector = mOutEdgeIdVector;
    }

    public void setOutlinePolygon(Polygon mOutlinePolygon) {
        this.mOutlinePolygon = mOutlinePolygon;
    }
}

