/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.util.ArrayList;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.renderer.VertexRenderer;

public class DefaultVertexRenderer
implements VertexRenderer {
    public static final Paint FILL_PAINT = Color.WHITE;
    public static final Paint LINE_PAINT = Color.BLACK;
    public static final Paint TEXT_PAINT = Color.BLACK;
    public static final Paint ERROR_PAINT = Color.RED;

    @Override
    public void draw(Graphics2D g2d, Vertex vertex) {
        this.drawOutline(g2d, vertex, FILL_PAINT, LINE_PAINT);
        this.drawName(g2d, vertex, TEXT_PAINT);
    }

    public void drawOutline(Graphics2D g2d, Vertex vertex, Paint fillPaint, Paint linePaint) {
        Polygon outline = vertex.getOutlinePolygon();
        g2d.setPaint(fillPaint);
        g2d.fill(outline);
        g2d.setPaint(linePaint);
        g2d.draw(outline);
    }

    public void drawOutline3DRect(Graphics2D g2d, Vertex vertex, Paint fillPaint) {
        this.drawOutline3DRect(g2d, vertex, fillPaint, null);
    }

    public void drawOutline3DRect(Graphics2D g2d, Vertex vertex, Paint fillPaint, Paint linePaint) {
        GraphPoint centrePoint = vertex.getCentrePoint();
        g2d.setPaint(fillPaint);
        g2d.fill3DRect(centrePoint.x - vertex.getWidth() / 2, centrePoint.y - vertex.getHeight() / 2, vertex.getWidth(), vertex.getHeight(), true);
        if (linePaint != null) {
            g2d.setPaint(linePaint);
            g2d.draw3DRect(centrePoint.x - vertex.getWidth() / 2, centrePoint.y - vertex.getHeight() / 2, vertex.getWidth(), vertex.getHeight(), true);
        }
    }

    public void drawOutlineRect(Graphics2D g2d, Vertex vertex, Paint fillPaint) {
        this.drawOutline3DRect(g2d, vertex, fillPaint, null);
    }

    public void drawOutlineRect(Graphics2D g2d, Vertex vertex, Paint fillPaint, Paint linePaint) {
        GraphPoint centrePoint = vertex.getCentrePoint();
        g2d.setPaint(fillPaint);
        g2d.fillRect(centrePoint.x - vertex.getWidth() / 2, centrePoint.y - vertex.getHeight() / 2, vertex.getWidth(), vertex.getHeight());
        if (linePaint != null) {
            g2d.setPaint(linePaint);
            g2d.drawRect(centrePoint.x - vertex.getWidth() / 2, centrePoint.y - vertex.getHeight() / 2, vertex.getWidth(), vertex.getHeight());
        }
    }

    public void drawText(Graphics2D g2d, Vertex vertex, String text, Paint textPaint) {
        GraphPoint centrePoint = vertex.getCentrePoint();
        FontMetrics metrics = g2d.getFontMetrics();
        int textWidth = metrics.stringWidth(text);
        int textHeight = metrics.getHeight();
        int textX = centrePoint.x - textWidth / 2;
        int textY = centrePoint.y + textHeight / 3;
        g2d.setPaint(textPaint);
        g2d.drawString(text, textX, textY);
    }

    public void drawName(Graphics2D g2d, Vertex vertex, Paint textPaint) {
        this.drawText(g2d, vertex, vertex.getName(), textPaint);
    }

    public void drawLinesOfTexts(Graphics2D g2d, Vertex vertex, ArrayList<String> linesOfText, Paint textPaint) {
        g2d.setPaint(textPaint);
        GraphPoint centrePoint = vertex.getCentrePoint();
        FontMetrics metrics = g2d.getFontMetrics();
        int lineHeight = metrics.getHeight();
        int linesHeight = lineHeight * linesOfText.size();
        int linesStartY = centrePoint.y - linesHeight / 2 + lineHeight * 2 / 3;
        int i = 0;
        for (String line : linesOfText) {
            if (line == null) {
                line = "";
            }
            int lineWidth = metrics.stringWidth(line);
            int x = centrePoint.x - lineWidth / 2;
            int y = linesStartY + i++ * lineHeight;
            g2d.drawString(line, x, y);
        }
    }
}

