/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.ArrayList;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.utils.Logger;

public class Workflow
extends CompositeActivity
implements C2KLocalObject {
    public History history;
    private ItemPath itemPath = null;
    private final TypeNameAndConstructionInfo[] mVertexTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("AND Split", "AndSplit"), new TypeNameAndConstructionInfo("OR Split", "OrSplit"), new TypeNameAndConstructionInfo("XOR Split", "XOrSplit"), new TypeNameAndConstructionInfo("Join", "Join"), new TypeNameAndConstructionInfo("Loop", "LoopSplit"), new TypeNameAndConstructionInfo("Activity", "Atomic"), new TypeNameAndConstructionInfo("Composite", "Composite")};
    private final TypeNameAndConstructionInfo[] mEdgeTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("Next", "Next")};

    public Workflow() {
    }

    public Workflow(CompositeActivity domain, PredefinedStepContainer predef) {
        this();
        domain.setName("domain");
        this.initChild(domain, true, new GraphPoint(150, 100));
        this.addChild(predef, new GraphPoint(300, 100));
    }

    public History getHistory(Object locker) throws InvalidDataException {
        if (locker != this) {
            return new History(this.itemPath, locker);
        }
        if (this.history == null) {
            if (this.itemPath == null) {
                throw new InvalidDataException("Workflow not initialized.");
            }
            this.history = new History(this.itemPath, this);
        }
        return this.history;
    }

    public History getHistory() throws InvalidDataException {
        return this.getHistory(this);
    }

    public TypeNameAndConstructionInfo[] getVertexTypeNameAndConstructionInfo() {
        return this.mVertexTypeNameAndConstructionInfo;
    }

    public TypeNameAndConstructionInfo[] getEdgeTypeNameAndConstructionInfo() {
        return this.mEdgeTypeNameAndConstructionInfo;
    }

    public String requestAction(AgentPath agent, AgentPath delegator, String stepPath, ItemPath itemPath, int transitionID, String requestData, String attachmentType, byte[] attachment) throws ObjectNotFoundException, AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectAlreadyExistsException, PersistencyException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        Logger.msg(3, "Workflow::requestAction() - transition:" + transitionID + " step:" + stepPath + " agent:" + agent, new Object[0]);
        GraphableVertex vert = this.search(stepPath);
        if (vert != null && vert instanceof Activity) {
            return ((Activity)vert).request(agent, delegator, itemPath, transitionID, requestData, attachmentType, attachment, this);
        }
        throw new ObjectNotFoundException(stepPath + " not found");
    }

    @Override
    public String getPath() {
        return "workflow";
    }

    @Override
    public String getName() {
        return "workflow";
    }

    @Override
    public String getType() {
        return "workflow";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public boolean verify() {
        for (int i = 0; i < this.getChildren().length; ++i) {
            if (((WfVertex)this.getChildren()[i]).verify()) continue;
            this.mErrors.add("error in children");
            return false;
        }
        return true;
    }

    @Override
    public Workflow getWf() {
        return this;
    }

    public void initialise(ItemPath itemPath, AgentPath agent, Object locker) throws InvalidDataException {
        this.setItemPath(itemPath);
        this.runFirst(agent, itemPath, locker);
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }

    public void setItemUUID(String uuid) throws InvalidItemPathException {
        this.setItemPath(new ItemPath(uuid));
    }

    public String getItemUUID() {
        return this.getItemPath().getUUID().toString();
    }

    public ArrayList<Job> calculateJobs(AgentPath agent, ItemPath itemPath, int type) throws InvalidAgentPathException, ObjectNotFoundException, InvalidDataException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (type != 1) {
            jobs.addAll(((CompositeActivity)this.search("workflow/domain")).calculateJobs(agent, itemPath, true));
        }
        if (type != 0) {
            jobs.addAll(((CompositeActivity)this.search("workflow/predefined")).calculateJobs(agent, itemPath, true));
        }
        return jobs;
    }

    @Override
    public boolean hasGoodNumberOfActivity() {
        return true;
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.LIFECYCLE;
    }

    @Override
    public String getClusterPath() {
        return (Object)((Object)this.getClusterType()) + "/workflow";
    }
}

