/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.AggregationDescription;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.DependencyDescription;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class AddNewCollectionDescription
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectAlreadyExistsException, PersistencyException {
        Object[] params = AddNewCollectionDescription.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "AddNewCollectionDescription: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params), new Object[0]);
        }
        if (params.length != 2) {
            throw new InvalidDataException("AddNewCollectionDescription: Invalid parameters " + Arrays.toString(params));
        }
        String collName = params[0];
        String collType = params[1];
        try {
            Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/last", locker);
            throw new ObjectAlreadyExistsException("Collection '" + collName + "' already exists");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            Collection newCollDesc;
            if (collType.equalsIgnoreCase("Aggregation")) {
                newCollDesc = new AggregationDescription(collName);
            } else if (collType.equalsIgnoreCase("Dependency")) {
                newCollDesc = new DependencyDescription(collName);
            } else {
                throw new InvalidDataException("AddNewCollectionDescription: Invalid type: '" + collType + "' /Aggregation or Dependency)");
            }
            try {
                Gateway.getStorage().put(item, newCollDesc, locker);
            }
            catch (PersistencyException e) {
                throw new PersistencyException("AddNewCollectionDescription: Error saving new collection '" + collName + "': " + e.getMessage());
            }
            return requestData;
        }
    }
}

