/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.Logger;

public class ClearSlot
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectCannotBeUpdated {
        Aggregation agg;
        int slotNo;
        String collName;
        Object[] params = ClearSlot.getDataList(requestData);
        if (Logger.doLog(3)) {
            Logger.msg(3, "ClearSlot: called by " + agent + " on " + item + " with parameters " + Arrays.toString(params), new Object[0]);
        }
        try {
            collName = params[0];
            slotNo = Integer.parseInt(params[1]);
        }
        catch (Exception e) {
            throw new InvalidDataException("ClearSlot: Invalid parameters " + Arrays.toString(params));
        }
        try {
            agg = (Aggregation)Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/last", locker);
        }
        catch (PersistencyException ex) {
            Logger.error(ex);
            throw new PersistencyException("ClearSlot: Error loading collection '" + collName + "': " + ex.getMessage());
        }
        boolean stored = false;
        for (AggregationMember member : agg.getMembers().list) {
            if (member.getID() != slotNo) continue;
            if (member.getItemPath() == null) {
                throw new ObjectCannotBeUpdated("ClearSlot: Member slot " + slotNo + " already empty");
            }
            member.clearItem();
            stored = true;
            break;
        }
        if (!stored) {
            throw new ObjectNotFoundException("ClearSlot: Member slot " + slotNo + " not found.");
        }
        try {
            Gateway.getStorage().put(item, agg, locker);
        }
        catch (PersistencyException e) {
            Logger.error(e);
            throw new PersistencyException("ClearSlot: Error storing collection");
        }
        return requestData;
    }
}

