/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.stateMachine;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;

public class State {
    int id;
    String name;
    boolean finished = false;
    HashMap<Integer, Transition> possibleTransitions = new HashMap();

    public State() {
    }

    public State(int id, String name) {
        this();
        this.id = id;
        this.name = name;
    }

    protected void addPossibleTransition(Transition possibleTransition) {
        this.possibleTransitions.put(possibleTransition.getId(), possibleTransition);
    }

    public Set<Integer> getPossibleTransitionIds() {
        return this.possibleTransitions.keySet();
    }

    public int getErrorTansitionId() {
        for (Map.Entry<Integer, Transition> entry : this.possibleTransitions.entrySet()) {
            if (!entry.getValue().isErrorHandler()) continue;
            return entry.getKey();
        }
        return -1;
    }

    public String toString() {
        return this.name + "[id:" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.id == ((State)other).id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public HashMap<Integer, Transition> getPossibleTransitions() {
        return this.possibleTransitions;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }
}

