/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.util.Iterator;
import java.util.Properties;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.ResourceLoader;
import org.cristalise.kernel.utils.Logger;

public class StandardServer
extends AbstractMain {
    protected static StandardServer server;

    public static void resetItemIORs(DomainPath root) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException {
        Logger.msg("StandardServer.resetItemIORs() - root:" + root, new Object[0]);
        Iterator<Path> pathes = Gateway.getLookup().getChildren(root);
        while (pathes.hasNext()) {
            DomainPath domain = (DomainPath)pathes.next();
            if (domain.isContext()) {
                StandardServer.resetItemIORs(domain);
                continue;
            }
            Logger.msg("StandardServer.resetItemIORs() - setting IOR for domain:" + domain + " item:" + domain.getItemPath(), new Object[0]);
            Gateway.getLookupManager().setIOR(domain.getItemPath(), Gateway.getORB().object_to_string(Gateway.getCorbaServer().getItemIOR(domain.getItemPath())));
        }
    }

    public static void resetAgentIORs(RolePath root) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException {
        Logger.msg("StandardServer.resetAgentIORs() - root:" + root, new Object[0]);
        Iterator<Path> roles = Gateway.getLookup().getChildren(root);
        while (roles.hasNext()) {
            RolePath role = (RolePath)roles.next();
            StandardServer.resetAgentIORs(role);
            for (AgentPath agent : Gateway.getLookup().getAgents(role)) {
                Logger.msg("StandardServer.resetAgentIORs() - setting IOR for role:" + role + " agent:" + agent.getAgentName() + " " + agent.getItemPath(), new Object[0]);
                Gateway.getLookupManager().setIOR(agent.getItemPath(), Gateway.getORB().object_to_string(Gateway.getCorbaServer().getAgentIOR(agent)));
            }
        }
    }

    public static void standardInitialisation(Properties props, ResourceLoader res) throws Exception {
        isServer = true;
        Gateway.init(props, res);
        Gateway.connect();
        Logger.initConsole("ItemServer");
        Gateway.startServer();
        if (Gateway.getProperties().containsKey("resetIOR")) {
            Logger.msg(5, "StandardServer.standardInitialisation() - RESETTING IORs", new Object[0]);
            StandardServer.resetItemIORs(new DomainPath(""));
            StandardServer.resetAgentIORs(new RolePath());
            AbstractMain.shutdown(0);
        } else {
            Gateway.runBoostrap();
        }
        Logger.msg(5, "StandardServer.standardInitialisation() - complete.", new Object[0]);
    }

    public static void standardInitialisation(String[] args) throws Exception {
        StandardServer.standardInitialisation(StandardServer.readC2KArgs(args), null);
    }

    public static void main(String[] args) throws Exception {
        StandardServer.standardInitialisation(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractMain.shutdown(0);
            }
        });
    }
}

