/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

public class ObjectProperties
extends Properties {
    private static final long serialVersionUID = 8214748637885650335L;

    public ObjectProperties() {
    }

    public ObjectProperties(Properties defaults) {
        super(defaults);
    }

    public String getString(String propName) {
        return this.getString(propName, null);
    }

    public String getString(String propName, String defaultValue) {
        String value = super.getProperty(propName, defaultValue);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public Object getObject(String propName) {
        return this.getObject(propName, null);
    }

    public Object getObject(String propName, Object defaultValue) {
        Object wValue = this.get(propName);
        if (wValue == null) {
            return defaultValue;
        }
        return wValue;
    }

    public boolean getBoolean(String aPropertyName) {
        return this.getBoolean(aPropertyName, Boolean.FALSE);
    }

    public boolean getBoolean(String aPropertyName, boolean defaultValue) {
        Object wValue = this.getObject(aPropertyName, defaultValue);
        if (wValue instanceof Boolean) {
            return (Boolean)wValue;
        }
        if (wValue instanceof String) {
            return Boolean.parseBoolean((String)wValue);
        }
        Logger.error("getBoolean(): unable to retrieve a int value for [" + aPropertyName + "]. Returning default value [" + defaultValue + "]. object found=" + wValue, new Object[0]);
        return defaultValue;
    }

    public int getInt(String aPropertyName) {
        return this.getInt(aPropertyName, -1);
    }

    public int getInt(String aPropertyName, int defaultValue) {
        Object wValue = this.getObject(aPropertyName, defaultValue);
        if (wValue instanceof Integer) {
            return (Integer)wValue;
        }
        if (wValue instanceof String) {
            try {
                return Integer.parseInt((String)wValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Logger.error("getInt(): unable to retrieve a int value for [" + aPropertyName + "]. Returning default value [" + defaultValue + "]. object found=" + wValue, new Object[0]);
        return defaultValue;
    }

    public void setProperty(String aPropertyName, Object aPropertyValue) {
        this.put(aPropertyName, aPropertyValue);
    }

    public void dumpProps(int logLevel) {
        Logger.msg(logLevel, "Properties:", new Object[0]);
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = this.getObject(name);
            if (value == null) {
                Logger.msg("    " + name + ": null", new Object[0]);
                continue;
            }
            Logger.msg("    " + name + " (" + this.getObject(name).getClass().getSimpleName() + "): '" + this.getObject(name).toString() + "'", new Object[0]);
        }
    }

    public Object getInstance(String propName, Object defaultVal) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object prop = this.getObject(propName, defaultVal);
        if (prop == null || prop.equals("")) {
            throw new InstantiationException("Property '" + propName + "' was not defined. Cannot instantiate.");
        }
        if (prop instanceof String) {
            return Class.forName(((String)prop).trim()).newInstance();
        }
        return prop;
    }

    public Object getInstance(String propName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.getInstance(propName, null);
    }

    public ArrayList<?> getInstances(String propName, Object defaultVal) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object val = this.getObject(propName, defaultVal);
        if (val == null) {
            return null;
        }
        if (val instanceof ArrayList) {
            return (ArrayList)val;
        }
        if (val instanceof String) {
            ArrayList<Object> retArr = new ArrayList<Object>();
            StringTokenizer tok = new StringTokenizer((String)val, ",");
            while (tok.hasMoreTokens()) {
                retArr.add(this.getInstance(tok.nextToken()));
            }
            return retArr;
        }
        ArrayList<Object> retArr = new ArrayList<Object>();
        retArr.add(val);
        return retArr;
    }

    public ArrayList<?> getInstances(String propName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.getInstances(propName, null);
    }

    private boolean propertiesToRedact(String key) {
        String keywordsToRedact = Gateway.getProperties().getString("SystemProperties.keywordsToRedact", "password,pwd");
        return StringUtils.containsAny((CharSequence)key.toLowerCase(), (CharSequence[])keywordsToRedact.split(","));
    }

    public Outcome convertToOutcome(String processName) throws IOException, InvalidDataException, ObjectNotFoundException {
        ArrayList props = new ArrayList();
        String templ = FileStringUtility.url2String(this.getClass().getResource("resources/templates/SystemProperties_xsd.tmpl"));
        CompiledTemplate expr = TemplateCompiler.compileTemplate((String)templ);
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("//")) continue;
            HashMap<String, Object> prop = new HashMap<String, Object>();
            prop.put("Name", key);
            prop.put("SetInConfigFiles", true);
            if (this.propertiesToRedact(key)) {
                prop.put("Value", "REDACTED");
            } else {
                prop.put("Value", entry.getValue());
            }
            props.add(prop);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("ProcessName", processName);
        vars.put("properties", props);
        String xml = (String)TemplateRuntime.execute((CompiledTemplate)expr, vars);
        Schema xsd = LocalObjectLoader.getSchema("SystemProperties", 0);
        return new Outcome(xml, xsd);
    }
}

