/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cristalise.kernel.utils.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlElementParser {
    public static String[] parse(String data, String xpath) {
        Node child;
        boolean match;
        int j;
        Document doc;
        DocumentBuilder builder;
        Vector<String> returnData = new Vector<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.error(e);
            throw new RuntimeException("Could not create XML Document Builder");
        }
        StringReader is = new StringReader(data);
        try {
            doc = builder.parse(new InputSource(is));
        }
        catch (Exception e) {
            Logger.error(e);
            throw new RuntimeException("Parser malfunction");
        }
        StringTokenizer pathTokens = new StringTokenizer(xpath, "/");
        int taille = pathTokens.countTokens();
        String[] pathElements = new String[taille];
        int i = taille;
        while (pathTokens.hasMoreElements()) {
            pathElements[--i] = pathTokens.nextToken();
        }
        if (Logger.doLog(6)) {
            StringBuffer sb = new StringBuffer("\n");
            for (String pathElement : pathElements) {
                sb.append("  " + pathElement + "\n");
            }
            Logger.msg("XmlElementParser.parse() - Path elements:" + sb, new Object[0]);
        }
        Logger.msg(6, "XmlElementParser.parse() - Looking for attribute " + pathElements[0] + " in " + pathElements[1], new Object[0]);
        NodeList nl = doc.getElementsByTagName(pathElements[1]);
        for (j = 0; j < nl.getLength(); ++j) {
            Logger.msg(6, "XmlElementParser.parse() - Found one", new Object[0]);
            Element e = (Element)nl.item(j);
            match = true;
            child = e;
            for (int k = 2; k < taille && match; ++k) {
                Logger.msg(6, "XmlElementParser.parse() - Checking parent " + pathElements[k], new Object[0]);
                child = child.getParentNode();
                if (!child.getNodeName().equals(pathElements[k])) {
                    Logger.msg(6, "XmlElementParser.parse() - No match for " + child.getNodeName(), new Object[0]);
                    match = false;
                    continue;
                }
                Logger.msg(6, "XmlElementParser.parse() - Match", new Object[0]);
            }
            if (!match || !e.hasAttribute(pathElements[0])) continue;
            Logger.msg(6, "XmlElementParser.parse() - Matching Attribute " + pathElements[0] + "=" + e.getAttribute(pathElements[0]), new Object[0]);
            returnData.add(e.getAttribute(pathElements[0]));
        }
        Logger.msg(6, "XmlElementParser.parse() - Looking for element " + pathElements[0], new Object[0]);
        nl = doc.getElementsByTagName(pathElements[0]);
        for (j = 0; j < nl.getLength(); ++j) {
            Logger.msg(6, "XmlElementParser.parse() - Found one", new Object[0]);
            Element e = (Element)nl.item(j);
            match = true;
            child = e;
            for (int k = 1; k < taille && match; ++k) {
                Logger.msg(6, "XmlElementParser.parse() - Checking parent " + pathElements[k], new Object[0]);
                child = child.getParentNode();
                if (!child.getNodeName().equals(pathElements[k])) {
                    Logger.msg(6, "XmlElementParser.parse() - No match for " + child.getNodeName(), new Object[0]);
                    match = false;
                    continue;
                }
                Logger.msg(6, "XmlElementParser.parse() - Match", new Object[0]);
            }
            if (!match) continue;
            String s = e.getFirstChild().getNodeValue();
            Logger.msg(6, "XmlElementParser.parse() - Found Element " + pathElements[0] + "=" + s, new Object[0]);
            if (s == null) continue;
            returnData.add(s);
        }
        Logger.msg(3, "XmlElementParser.parse() - " + returnData.size() + " values found for " + xpath, new Object[0]);
        String[] returnArray = new String[returnData.size()];
        for (j = 0; j < returnArray.length; ++j) {
            returnArray[j] = (String)returnData.get(j);
        }
        return returnArray;
    }
}

