/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.cristalise.kernel.utils.Logger;
import org.cristalise.kernel.utils.server.SocketHandler;

public class SimpleTCPIPServer
implements Runnable {
    int port = 0;
    int maxConn = 10;
    Thread listener = null;
    Class<?> handlerClass = null;
    ServerSocket serverSocket = null;
    boolean keepListening = true;
    ArrayList<SocketHandler> currentHandlers = new ArrayList();
    static short numberOfServers = 0;

    public SimpleTCPIPServer(int port, Class<?> handlerClass, int maxConnections) {
        this.port = port;
        this.handlerClass = handlerClass;
        this.maxConn = maxConnections;
        numberOfServers = (short)(numberOfServers + 1);
    }

    public void startListening() {
        if (this.listener != null) {
            return;
        }
        this.keepListening = true;
        this.listener = new Thread(this);
        this.listener.start();
    }

    public void stopListening() {
        Logger.msg("SimpleTCPIPServer.stopListening() - Closing server for " + this.handlerClass.getName() + " on port " + this.port, new Object[0]);
        this.keepListening = false;
        for (SocketHandler thisHandler : this.currentHandlers) {
            thisHandler.shutdown();
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("TCP/IP Server for class " + this.handlerClass.getName());
        Socket connectionSocket = null;
        try {
            this.serverSocket = new ServerSocket(this.port);
            if (this.port == 0) {
                this.port = this.serverSocket.getLocalPort();
            }
            Logger.msg("SimpleTCPIPServer.run() - Created server for " + this.handlerClass.getName() + " on port " + this.port, new Object[0]);
            this.serverSocket.setSoTimeout(500);
            SocketHandler freeHandler = null;
            while (this.keepListening) {
                if (freeHandler == null || freeHandler.isBusy()) {
                    ListIterator<SocketHandler> i = this.currentHandlers.listIterator();
                    try {
                        while ((freeHandler = i.next()).isBusy()) {
                        }
                    }
                    catch (NoSuchElementException e) {
                        if (this.currentHandlers.size() < this.maxConn) {
                            freeHandler = (SocketHandler)this.handlerClass.newInstance();
                            this.currentHandlers.add(freeHandler);
                        }
                        Logger.warning("No free handlers left for " + this.handlerClass.getName() + " on port " + this.port + "! Sleeping 2s.", new Object[0]);
                        Thread.sleep(2000L);
                        continue;
                    }
                }
                try {
                    connectionSocket = this.serverSocket.accept();
                    if (!this.keepListening) continue;
                    Logger.msg("SimpleTCPIPServer: Connection to " + freeHandler.getName() + " from " + connectionSocket.getInetAddress(), new Object[0]);
                    freeHandler.setSocket(connectionSocket);
                    new Thread(freeHandler).start();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (SocketException socketException) {}
            }
            this.serverSocket.close();
            Logger.msg("SimpleTCPIPServer: Server closed for " + this.handlerClass.getName() + " on port " + this.port, new Object[0]);
        }
        catch (Exception ex) {
            Logger.error("SimpleTCPIPServer.run(): Fatal Error. Listener for '" + this.handlerClass.getName() + "' will stop.", new Object[0]);
            Logger.error(ex);
        }
        this.listener = null;
        numberOfServers = (short)(numberOfServers - 1);
        Logger.msg("SimpleTCPIPServer - Servers still running: " + numberOfServers, new Object[0]);
    }

    public int getPort() {
        return this.port;
    }
}

