/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMemberList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyDescription;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.Logger;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class UpdateCollectionsFromDescription
extends PredefinedStep {
    public static final String description = "Updates the Collections of the Item from its description";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException, AccessRightsException {
        ItemPath descItemPath;
        Object[] inputs = UpdateCollectionsFromDescription.getDataList(requestData);
        if (inputs.length != 2 && inputs.length != 3) {
            throw new InvalidDataException("Invalid nunber of inputs:" + Arrays.toString(inputs));
        }
        String descPath = inputs[0];
        String descVer = inputs[1];
        CollectionMemberList newMembers = null;
        try {
            if (inputs.length == 3) {
                newMembers = (CollectionMemberList)Gateway.getMarshaller().unmarshall((String)inputs[2]);
            }
        }
        catch (IOException | MappingException | MarshalException | ValidationException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
        try {
            descItemPath = Gateway.getLookup().resolvePath(new DomainPath(descPath));
        }
        catch (InvalidItemPathException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
        PropertyArrayList newItemProps = new PropertyArrayList();
        ArrayList<String> currentCollNames = new ArrayList<String>(Arrays.asList(Gateway.getStorage().getClusterContents(item, ClusterType.COLLECTION)));
        for (String collName : Gateway.getStorage().getClusterContents(descItemPath, ClusterType.COLLECTION, locker)) {
            if (!currentCollNames.contains(collName)) {
                Collection<?> newColl = CreateItemFromDescription.instantiateCollection(collName, descItemPath, descVer, newItemProps, locker);
                if (newColl == null) continue;
                Gateway.getStorage().put(item, newColl, locker);
                continue;
            }
            currentCollNames.remove(collName);
            Dependency itemColl = UpdateCollectionsFromDescription.updateDependencyProperties(item, descItemPath, descVer, collName, locker);
            UpdateCollectionsFromDescription.updateDependencyMembers(itemColl, newMembers);
            Gateway.getStorage().put(item, itemColl, locker);
        }
        for (Property p : newItemProps.list) {
            PropertyUtility.writeProperty(item, p.getName(), p.getValue(), locker);
        }
        for (String collName : currentCollNames) {
            Gateway.getStorage().remove(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName, locker);
        }
        return requestData;
    }

    private static void updateDependencyMembers(Dependency itemColl, CollectionMemberList<DependencyMember> newMembers) throws ObjectNotFoundException, InvalidCollectionModification {
        for (DependencyMember currentMember : itemColl.getMembers().list) {
            DependencyMember newMember = null;
            if (newMembers != null) {
                newMember = newMembers.list.stream().filter(aMember -> currentMember.getItemPath().equals(aMember.getItemPath())).findAny().orElse(null);
            }
            currentMember.updatePropertieFromDescription(itemColl.getProperties(), newMember);
        }
    }

    private static Dependency updateDependencyProperties(ItemPath item, ItemPath descItemPath, String descVer, String collName, Object locker) throws PersistencyException, ObjectNotFoundException {
        HashMap<String, Object> newCollProps = new HashMap<String, Object>();
        DependencyDescription collOfDesc = (DependencyDescription)Gateway.getStorage().get(descItemPath, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/" + descVer, locker);
        newCollProps.putAll(collOfDesc.getProperties());
        PropertyDescriptionList itemPropertyList = PropertyUtility.getPropertyDescriptionOutcome(((DependencyMember)collOfDesc.getMembers().list.get(0)).getItemPath(), descVer, locker);
        for (PropertyDescription prop : itemPropertyList.list) {
            if (!prop.getIsClassIdentifier() && !prop.isTransitive()) continue;
            newCollProps.put(prop.getName(), prop.getDefaultValue());
        }
        Dependency itemColl = (Dependency)Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/" + descVer, locker);
        Iterator iterator = itemColl.getProperties().keySet().iterator();
        while (iterator.hasNext()) {
            String keyStr = (String)iterator.next();
            if (newCollProps.containsKey(keyStr)) continue;
            iterator.remove();
        }
        for (Map.Entry propDef : newCollProps.entrySet()) {
            itemColl.getProperties().put(propDef.getKey(), propDef.getValue());
        }
        if (itemPropertyList != null) {
            itemColl.setClassProps(itemPropertyList.getClassProps());
        }
        return itemColl;
    }
}

