/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.agent;

import java.security.NoSuchAlgorithmException;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.cristalise.kernel.utils.Logger;

public class SetAgentPassword
extends PredefinedStep {
    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, AccessRightsException {
        String[] params = SetAgentPassword.getDataList(requestData);
        Logger.msg(3, "SetAgentPassword: called by " + agent + " on " + item + " with parameters length:" + params.length, new Object[0]);
        if (params.length != 1 && params.length != 2) {
            throw new InvalidDataException("SetAgentPassword: Invalid number of parameters length:" + params.length);
        }
        try {
            String newPwd;
            AgentPath targetAgent = new AgentPath(item);
            if (!targetAgent.equals(agent) && !agent.hasRole(BuiltInAuthc.ADMIN_ROLE.getName())) {
                throw new AccessRightsException("Agent passwords may only be set by those Agents or by an Administrator");
            }
            if (params.length == 1) {
                newPwd = params[0];
                params[0] = "REDACTED";
            } else {
                try {
                    Gateway.getSecurityManager().authenticate(agent.getAgentName(), params[0], null);
                }
                catch (Exception e) {
                    throw new AccessRightsException("Authentication failed");
                }
                newPwd = params[1];
                params[0] = "REDACTED";
                params[1] = "REDACTED";
            }
            Gateway.getLookupManager().setAgentPassword(targetAgent, newPwd, !targetAgent.equals(agent));
            return SetAgentPassword.bundleData(params);
        }
        catch (InvalidItemPathException ex) {
            Logger.error(ex);
            throw new InvalidDataException("Can only set password on an Agent. " + item + " is an Item.");
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(e);
            throw new InvalidDataException("Cryptographic libraries for password hashing not found.");
        }
    }
}

