/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.stateMachine;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.stateMachine.State;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.Logger;

public class StateMachine
implements DescriptionObject {
    public String name;
    public Integer version;
    public ItemPath itemPath;
    private ArrayList<State> states = new ArrayList();
    private ArrayList<Transition> transitions = new ArrayList();
    private final HashMap<Integer, State> stateCodes = new HashMap();
    private final HashMap<Integer, Transition> transitionCodes = new HashMap();
    State initialState;
    int initialStateCode;
    boolean isCoherent = false;
    private int nextStateId = -1;
    private int nextTransId = -1;

    public StateMachine() {
    }

    public StateMachine(String name, Integer version) {
        this();
        this.name = name;
        this.version = version;
    }

    private int getNextStateId() {
        if (this.nextStateId == -1) {
            for (State s : this.states) {
                if (s.id <= this.nextStateId) continue;
                this.nextStateId = s.id;
            }
            ++this.nextStateId;
        }
        return this.nextStateId++;
    }

    private int getNextTransId() {
        if (this.nextTransId == -1) {
            for (Transition t : this.transitions) {
                if (t.id <= this.nextTransId) continue;
                this.nextTransId = t.id;
            }
            ++this.nextTransId;
        }
        return this.nextTransId++;
    }

    public State createState(String name) {
        State newState = new State(this.getNextStateId(), name);
        this.states.add(newState);
        Logger.msg(5, "StateMachine.createState() - created:" + name + " id:" + newState.id, new Object[0]);
        return newState;
    }

    public Transition createTransition(String name) {
        Transition newTrans = new Transition(this.getNextTransId(), name);
        this.transitions.add(newTrans);
        Logger.msg(5, "StateMachine.createTransition() - created:" + name + " id:" + newTrans.id, new Object[0]);
        return newTrans;
    }

    public void setStates(ArrayList<State> newStates) {
        this.states = newStates;
        this.validate();
    }

    public void setTransitions(ArrayList<Transition> newTransitions) {
        this.transitions = newTransitions;
        this.validate();
    }

    public boolean validate() {
        this.stateCodes.clear();
        this.transitionCodes.clear();
        this.isCoherent = true;
        Logger.msg(5, "StateMachine.validate() - name:'" + this.name + "'", new Object[0]);
        for (State state : this.states) {
            Logger.debug(8, "State     : " + state, new Object[0]);
            this.stateCodes.put(state.getId(), state);
        }
        if (this.stateCodes.containsKey(this.initialStateCode)) {
            this.initialState = this.stateCodes.get(this.initialStateCode);
        } else {
            this.isCoherent = false;
        }
        for (Transition trans : this.transitions) {
            Logger.debug(8, "Transition: " + trans, new Object[0]);
            this.transitionCodes.put(trans.getId(), trans);
            this.isCoherent = this.isCoherent && trans.resolveStates(this.stateCodes);
        }
        return this.isCoherent;
    }

    public ArrayList<State> getStates() {
        return this.states;
    }

    public ArrayList<Transition> getTransitions() {
        return this.transitions;
    }

    public State getInitialState() {
        return this.initialState;
    }

    public void setInitialState(State initialState) {
        this.initialState = initialState;
        this.initialStateCode = initialState.getId();
    }

    public int getInitialStateCode() {
        return this.initialStateCode;
    }

    public void setInitialStateCode(int initialStateCode) {
        this.initialStateCode = initialStateCode;
        this.initialState = this.stateCodes.get(initialStateCode);
        if (this.initialState == null) {
            this.isCoherent = false;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public ItemPath getItemPath() {
        return this.itemPath;
    }

    @Override
    public void setItemPath(ItemPath path) {
        this.itemPath = path;
    }

    @Override
    public String getItemID() {
        if (this.itemPath == null || this.itemPath.getUUID() == null) {
            return "";
        }
        return this.itemPath.getUUID().toString();
    }

    public Transition getTransition(int transitionID) {
        return this.transitionCodes.get(transitionID);
    }

    public Transition getTransition(String name) {
        for (Transition t : this.transitions) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public int getTransitionID(String name) {
        Transition t = this.getTransition(name);
        return t == null ? -1 : t.getId();
    }

    public int getValidTransitionID(String transName) throws InvalidDataException {
        int id = this.getTransitionID(transName);
        if (id == -1) {
            throw new InvalidDataException("Transition name '" + transName + "' was not found in StateMachine '" + this.getName() + "'");
        }
        return id;
    }

    public State getState(int stateID) {
        return this.stateCodes.get(stateID);
    }

    public State getState(String name) {
        for (State s : this.states) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @Override
    public CollectionArrayList makeDescCollections() {
        return new CollectionArrayList();
    }

    public Map<Transition, String> getPossibleTransitions(Activity act, AgentPath agent) throws ObjectNotFoundException, InvalidDataException {
        HashMap<Transition, String> returnList = new HashMap<Transition, String>();
        State currentState = this.getState(act.getState());
        for (Transition possTrans : currentState.getPossibleTransitions().values()) {
            try {
                if (possTrans.isEnabled(act)) {
                    returnList.put(possTrans, possTrans.getPerformingRole(act, agent));
                    continue;
                }
                Logger.msg(7, "StetMachine.getPossibleTransitions() - DISABLED trans:" + possTrans + " act:" + act.getName(), new Object[0]);
            }
            catch (AccessRightsException ex) {
                Logger.msg(5, "StetMachine.getPossibleTransitions() - trans:" + possTrans + " not possible for " + agent.getAgentName() + " exception:" + ex.getMessage(), new Object[0]);
                if (!Logger.doLog(8)) continue;
                Logger.error(ex);
            }
        }
        return returnList;
    }

    public State traverse(Activity act, Transition transition, AgentPath agent) throws InvalidTransitionException, AccessRightsException, ObjectNotFoundException, InvalidDataException {
        State currentState = this.getState(act.getState());
        if (transition.originState.equals(currentState)) {
            transition.getPerformingRole(act, agent);
            return transition.targetState;
        }
        throw new InvalidTransitionException("Transition '" + transition + "' not valid from state '" + currentState.getName() + "'");
    }

    public boolean isCoherent() {
        return this.isCoherent;
    }

    public int getErrorTransitionIdForState(int id) {
        return this.getState(id).getErrorTansitionId();
    }

    @Override
    public void export(Writer imports, File dir, boolean shallow) throws IOException, InvalidDataException {
        String smXML;
        String typeCode = BuiltInResources.STATE_MACHINE_RESOURCE.getTypeCode();
        String fileName = this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml";
        try {
            smXML = Gateway.getMarshaller().marshall(this);
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException("Couldn't marshall state machine " + this.getName());
        }
        FileStringUtility.string2File(new File(new File(dir, typeCode), fileName), smXML);
        if (imports == null) {
            return;
        }
        if (Gateway.getProperties().getBoolean("Resource.useOldImportFormat", false)) {
            imports.write("<Resource name='" + this.getName() + "' " + (this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (this.getVersion() == null ? "" : "version='" + this.getVersion() + "' ") + "type='" + typeCode + "'>boot/" + typeCode + "/" + fileName + "</Resource>\n");
        } else {
            imports.write("<StateMachineResource name='" + this.getName() + "' " + (this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (this.getVersion() == null ? "" : "version='" + this.getVersion() + "'") + "/>\n");
        }
    }
}

