/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.OutcomeValidator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Outcome
implements C2KLocalObject {
    private static final String DTM_MANAGER_NAME = "com.sun.org.apache.xml.internal.dtm.DTMManager";
    private static final String DTM_MANAGER_VALUE = "com.sun.org.apache.xml.internal.dtm.ref.DTMManagerDefault";
    private static final int NONE = -1;
    Integer mID;
    Schema mSchema;
    Document mDOM;
    static DocumentBuilder parser;
    private static final ThreadLocal<XPathFactory> XPATH_FACTORY;

    public Outcome(String xml) throws InvalidDataException {
        this(-1, xml, null);
    }

    public Outcome(String xml, Schema schema) throws InvalidDataException {
        this(-1, xml, schema);
    }

    public Outcome(int id, String xml, Schema schema) throws InvalidDataException {
        this(id, (Document)null, schema);
        try {
            this.mDOM = Outcome.parse(xml);
        }
        catch (IOException | SAXException ex) {
            Logger.error("INVALID XML - schema:" + (null == this.mSchema ? null : this.mSchema.getName()) + "\n" + xml, new Object[0]);
            Logger.error(ex);
            throw new InvalidDataException("XML not valid for schema:" + this.mSchema + " error:" + ex.getMessage());
        }
    }

    public Outcome(int id, Document dom, Schema schema) {
        this.mID = id;
        this.mDOM = dom;
        this.mSchema = schema;
    }

    public Outcome(String path, String xml) throws PersistencyException, InvalidDataException {
        this.setMetaDataFromPath(path);
        try {
            this.mDOM = Outcome.parse(xml);
        }
        catch (IOException | SAXException ex) {
            Logger.error(ex);
            throw new InvalidDataException("XML not valid: " + ex.getMessage());
        }
    }

    public Outcome(String path, Document data) throws PersistencyException, InvalidDataException {
        this.setMetaDataFromPath(path);
        this.mDOM = data;
    }

    protected void setMetaDataFromPath(String path) throws PersistencyException, InvalidDataException {
        StringTokenizer tok = new StringTokenizer(path, "/");
        if (tok.countTokens() != 3 && !tok.nextToken().equals(ClusterType.OUTCOME.getName())) {
            throw new PersistencyException("Outcome() - Outcome path must have three components:" + path);
        }
        String schemaName = tok.nextToken();
        String verString = tok.nextToken();
        String objId = tok.nextToken();
        try {
            Integer schemaVersion = Integer.valueOf(verString);
            this.mSchema = LocalObjectLoader.getSchema(schemaName, schemaVersion);
            this.mID = Integer.valueOf(objId);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Outcome() - Version or EventID was an invalid number version:" + verString + " eventID:" + objId);
        }
        catch (ObjectNotFoundException e) {
            Logger.error(e);
            throw new InvalidDataException("Outcome() - problem loading schema:" + schemaName + " version:" + verString);
        }
    }

    public Object evaluateXpath(String xpathExpr, QName returnType) throws XPathExpressionException {
        XPath xpath = XPATH_FACTORY.get().newXPath();
        return xpath.compile(xpathExpr).evaluate(this.mDOM, returnType);
    }

    public String validate() throws InvalidDataException {
        if (this.mSchema == null) {
            this.mDOM.normalize();
            throw new InvalidDataException("Schema was NOT provided");
        }
        OutcomeValidator validator = OutcomeValidator.getValidator(this.mSchema);
        if (Gateway.getProperties().getBoolean("Outcome.Validation.useDOM", true)) {
            return validator.validate(this.mDOM);
        }
        return validator.validate(this.getData());
    }

    public void validateAndCheck() throws InvalidDataException {
        String error = this.validate();
        if (StringUtils.isNotBlank((CharSequence)error)) {
            Logger.error("Outcome.validateAndCheck() - Outcome not valid: " + error, new Object[0]);
            Logger.msg("XML: \n" + this.getData(), new Object[0]);
            Logger.msg("XSD: \n" + this.getSchema().getXSD(), new Object[0]);
            throw new InvalidDataException(error);
        }
    }

    @Override
    public void setName(String name) {
        try {
            this.mID = Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            Logger.error("Invalid id set on Outcome:" + name, new Object[0]);
        }
    }

    @Override
    public String getName() {
        return this.mID.toString();
    }

    public void setData(String xml) throws SAXException, IOException {
        this.mDOM = Outcome.parse(xml);
    }

    public String getNodeValue(Node node) throws InvalidDataException {
        short type = node.getNodeType();
        if (type == 3 || type == 4 || type == 2) {
            return node.getNodeValue();
        }
        if (type == 1) {
            NodeList nodeChildren = node.getChildNodes();
            if (nodeChildren.getLength() == 0) {
                Logger.msg(5, "Outcome.getNodeValue() - No child/text node for node:" + node.getNodeName() + " => returning null", new Object[0]);
                return null;
            }
            if (nodeChildren.getLength() == 1) {
                Node child = nodeChildren.item(0);
                if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                    return child.getNodeValue();
                }
                throw new InvalidDataException("Node '" + node.getNodeName() + "' can't get data from child node name:" + child.getNodeName() + " type:" + type);
            }
            throw new InvalidDataException("Node '" + node.getNodeName() + "' shall have 0 or 1 children only #children:" + nodeChildren.getLength());
        }
        throw new InvalidDataException("Cannot handle node name:" + node.getNodeName() + " type:" + type);
    }

    public void setNodeValue(Node node, String value) throws InvalidDataException {
        this.setNodeValue(node, value, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setNodeValue(Node node, String value, boolean useCdata) throws InvalidDataException {
        short type = node.getNodeType();
        if (type == 3 || type == 4 || type == 2) {
            if (useCdata && type != 4) {
                throw new InvalidDataException("Node '" + node.getNodeName() + "' can't set cdata of attribute or text node");
            }
            node.setNodeValue(value);
            return;
        } else if (type == 1) {
            NodeList nodeChildren = node.getChildNodes();
            if (nodeChildren.getLength() == 0) {
                if (useCdata) {
                    node.appendChild(this.mDOM.createCDATASection(value));
                    return;
                } else {
                    node.appendChild(this.mDOM.createTextNode(value));
                }
                return;
            } else {
                if (nodeChildren.getLength() != 1) throw new InvalidDataException("Node '" + node.getNodeName() + "' shall have 0 or 1 children only #children:" + nodeChildren.getLength());
                Node child = nodeChildren.item(0);
                switch (child.getNodeType()) {
                    case 3: {
                        if (useCdata) {
                            node.replaceChild(this.mDOM.createCDATASection(value), child);
                            return;
                        }
                    }
                    case 4: {
                        child.setNodeValue(value);
                        return;
                    }
                    default: {
                        throw new InvalidDataException("Node '" + node.getNodeName() + "' can't set child node of type " + child.getNodeType());
                    }
                }
            }
        } else {
            if (type != 2) throw new InvalidDataException("Cannot handle node name:" + node.getNodeName() + " typeCode:" + type);
            if (useCdata) {
                throw new InvalidDataException("Node '" + node.getNodeName() + "' can't set cdata of attribute");
            }
            node.setNodeValue(value);
        }
    }

    public String getFieldByXPath(String xpath) throws XPathExpressionException, InvalidDataException {
        Node field = this.getNodeByXPath(xpath);
        if (field == null) {
            throw new InvalidDataException("Cannot resolve xpath:" + xpath);
        }
        return this.getNodeValue(field);
    }

    private boolean hasSingleField(NodeList elements) {
        return elements != null && elements.getLength() > 0 && elements.item(0).getNodeType() == 1;
    }

    public void setAttribute(Element element, String name, String data, boolean remove) throws InvalidDataException {
        if (data == null && remove) {
            Logger.msg(7, "Outcome.setAttribute() - removing name:" + name, new Object[0]);
            if (element.hasAttribute(name)) {
                element.removeAttribute(name);
            }
            return;
        }
        if (!element.hasAttribute(name)) {
            throw new InvalidDataException("Invalid name:'" + name + "'");
        }
        element.getAttributeNode(name).setValue(data);
    }

    public void setAttribute(Element element, String name, String data) throws InvalidDataException {
        this.setAttribute(element, name, data, false);
    }

    public void setAttribute(String name, String data, boolean remove) throws InvalidDataException {
        this.setAttribute(this.mDOM.getDocumentElement(), name, data, remove);
    }

    public void setAttribute(String name, String data) throws InvalidDataException {
        this.setAttribute(name, data, false);
    }

    public void setAttributeOfField(String field, String name, String data, boolean remove) throws InvalidDataException {
        NodeList elements = this.mDOM.getDocumentElement().getElementsByTagName(field);
        if (!this.hasSingleField(elements)) {
            throw new InvalidDataException("'" + field + "' is invalid or not a single field");
        }
        this.setAttribute((Element)elements.item(0), name, data, remove);
    }

    public void setAttributeOfField(String field, String name, String data) throws InvalidDataException {
        this.setAttributeOfField(field, name, data, false);
    }

    public void setField(Element element, String name, String data, boolean remove) throws InvalidDataException {
        NodeList elements = element.getElementsByTagName(name);
        if (this.hasSingleField(elements)) {
            if (data == null && remove) {
                Logger.msg(7, "Outcome.setField() - removing name:" + name, new Object[0]);
                element.removeChild(elements.item(0));
                return;
            }
            if (data == null) {
                data = "";
            }
        } else {
            throw new InvalidDataException("'" + name + "' is invalid or not a single field");
        }
        this.setNodeValue(elements.item(0), data);
    }

    public void setField(Element element, String name, String data) throws InvalidDataException {
        this.setField(element, name, data, false);
    }

    public void setField(String name, String data, boolean remove) throws InvalidDataException {
        this.setField(this.mDOM.getDocumentElement(), name, data, remove);
    }

    public void setField(String name, String data) throws InvalidDataException {
        this.setField(name, data, false);
    }

    public void setFieldByXPath(String xpath, String data) throws XPathExpressionException, InvalidDataException {
        this.setFieldByXPath(xpath, data, false);
    }

    public void setFieldByXPath(String xpath, String data, boolean remove) throws XPathExpressionException, InvalidDataException {
        Node field;
        if (StringUtils.isBlank((CharSequence)xpath)) {
            throw new InvalidDataException("Xpath is null or empty string");
        }
        if (data == null && remove) {
            Logger.msg(7, "Outcome.setFieldByXPath() - removing field xpath", new Object[0]);
            this.removeNodeByXPath(xpath);
            return;
        }
        if (data == null) {
            data = "";
        }
        if ((field = this.getNodeByXPath(xpath)) == null) {
            Logger.error(this.getData(), new Object[0]);
            throw new InvalidDataException("Xpath '" + xpath + "' is invalid");
        }
        this.setNodeValue(field, data);
    }

    public Node appendXmlFragment(String xpath, String xmlFragment) throws InvalidDataException {
        try {
            Node parentNode = this.getNodeByXPath(xpath);
            Element newNode = Outcome.parse(xmlFragment).getDocumentElement();
            return parentNode.appendChild(this.mDOM.importNode(newNode, true));
        }
        catch (IOException | XPathExpressionException | SAXException e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public String getData() {
        try {
            return Outcome.serialize(this.mDOM, false);
        }
        catch (InvalidDataException e) {
            Logger.error(e);
            return null;
        }
    }

    @Deprecated
    public String getSchemaType() {
        if (this.mSchema == null) {
            throw new IllegalArgumentException("Outcome must have valid Schema");
        }
        return this.mSchema.getName();
    }

    @Deprecated
    public int getSchemaVersion() {
        if (this.mSchema == null) {
            throw new IllegalArgumentException("Outcome must have valid Schema");
        }
        return this.mSchema.getVersion();
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.OUTCOME;
    }

    @Override
    public String getClusterPath() {
        if (this.mID == null || this.mID == -1 || this.mSchema == null) {
            throw new IllegalArgumentException("Outcome must have valid ID and Schema");
        }
        return (Object)((Object)this.getClusterType()) + "/" + this.mSchema.getName() + "/" + this.mSchema.getVersion() + "/" + this.mID;
    }

    public static Document newDocument() throws SAXException, IOException {
        return Outcome.parse((InputSource)null);
    }

    public static Document parse(String xml) throws SAXException, IOException {
        return Outcome.parse(new InputSource(new StringReader(xml)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(InputSource xml) throws SAXException, IOException {
        DocumentBuilder documentBuilder = parser;
        synchronized (documentBuilder) {
            if (xml != null) {
                return parser.parse(xml);
            }
            return parser.newDocument();
        }
    }

    public String getAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return null;
    }

    public String getAttribute(String name) {
        return this.getAttribute(this.mDOM.getDocumentElement(), name);
    }

    public String getAttributeOfField(String field, String attribute) {
        NodeList elements = this.mDOM.getDocumentElement().getElementsByTagName(field);
        if (this.hasSingleField(elements)) {
            String value = ((Element)elements.item(0)).getAttribute(attribute);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return value;
            }
            return null;
        }
        Logger.warning("Outcome.getAttributeOfField() - '%s' is invalid or not a single field", field);
        return null;
    }

    public String getField(Element element, String name) {
        try {
            NodeList elements = element.getElementsByTagName(name);
            if (this.hasSingleField(elements)) {
                if (elements.getLength() > 1) {
                    Logger.warning("Outcome.getField() - '%s' was found multiple times, returning first occurance", name);
                }
                return this.getNodeValue(elements.item(0));
            }
            Logger.warning("Outcome.getField() - '%s' is invalid or not a single field", name);
        }
        catch (InvalidDataException e) {
            Logger.warning("Outcome.getField() - exception:" + e.getMessage(), new Object[0]);
        }
        return null;
    }

    public String getField(String name) {
        return this.getField(this.mDOM.getDocumentElement(), name);
    }

    public NodeList getNodesByXPath(String xpathExpr) throws XPathExpressionException {
        return (NodeList)this.evaluateXpath(xpathExpr, XPathConstants.NODESET);
    }

    public Node getNodeByXPath(String xpathExpr) throws XPathExpressionException {
        return (Node)this.evaluateXpath(xpathExpr, XPathConstants.NODE);
    }

    public Node removeNodeByXPath(String xpathExpr) throws XPathExpressionException, InvalidDataException {
        if (StringUtils.isBlank((CharSequence)xpathExpr)) {
            throw new InvalidDataException("Xpath is null or empty string");
        }
        Node nodeToTemove = this.getNodeByXPath(xpathExpr);
        if (nodeToTemove == null) {
            Logger.error("Xpath '" + xpathExpr + "' is invalid\n" + this.getData(), new Object[0]);
            throw new InvalidDataException("Xpath '" + xpathExpr + "' is invalid");
        }
        return nodeToTemove.getParentNode().removeChild(nodeToTemove);
    }

    public static String serialize(Node node, boolean prettyPrint) throws InvalidDataException {
        Transformer transformer;
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            Logger.error(ex);
            return "";
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", prettyPrint ? "yes" : "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter out = new StringWriter();
        try {
            transformer.transform(new DOMSource(node), new StreamResult(out));
        }
        catch (Exception e) {
            Logger.error(e);
            throw new InvalidDataException(e.getMessage());
        }
        return ((Object)out).toString();
    }

    public Map<String, String> getRecordOfNode(Node node) {
        HashMap<String, String> record = new HashMap<String, String>();
        NodeList elements = node.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            if (elements.item(i).getNodeType() != 1) continue;
            String name = elements.item(i).getNodeName();
            String value = elements.item(i).getTextContent();
            record.put(name, value);
        }
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.item(i).getNodeName();
            String value = attrs.item(i).getTextContent();
            record.put(name, value);
        }
        return record;
    }

    public Map<String, String> getRecord() {
        return this.getRecordOfNode(this.mDOM.getDocumentElement());
    }

    public Map<String, String> getRecord(String xpath) throws XPathExpressionException {
        return this.getRecordOfNode(this.getNodeByXPath(xpath));
    }

    public List<Map<String, String>> getAllRecords(String xpath) throws XPathExpressionException {
        ArrayList<Map<String, String>> records = new ArrayList<Map<String, String>>();
        NodeList nodes = this.getNodesByXPath(xpath);
        for (int i = 0; i < nodes.getLength(); ++i) {
            records.add(this.getRecordOfNode(nodes.item(i)));
        }
        return records;
    }

    public List<String> getRecordOfElement(Element element, List<String> names) {
        ArrayList<String> record = new ArrayList<String>();
        for (String name : names) {
            String value = this.getField(element, name);
            if (value == null) {
                value = this.getAttribute(element, name);
            }
            record.add(value);
        }
        return record;
    }

    public List<String> getRecord(List<String> names) {
        ArrayList<String> record = new ArrayList<String>();
        for (String name : names) {
            String value = this.getField(name);
            if (value == null) {
                value = this.getAttribute(name);
            }
            record.add(value);
        }
        return record;
    }

    public List<String> getRecord(String xpath, List<String> names) throws XPathExpressionException {
        return this.getRecordOfElement((Element)this.getNodeByXPath(xpath), names);
    }

    public List<List<String>> getAllRecords(String xpath, List<String> names) throws XPathExpressionException {
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        NodeList nodes = this.getNodesByXPath(xpath);
        for (int i = 0; i < nodes.getLength(); ++i) {
            records.add(this.getRecordOfElement((Element)nodes.item(i), names));
        }
        return records;
    }

    public void setRecord(Map<String, String> record) throws InvalidDataException {
        this.setRecord(this.mDOM.getDocumentElement(), record);
    }

    public void setRecord(String xpath, Map<String, String> record) throws InvalidDataException, XPathExpressionException {
        this.setRecord((Element)this.getNodeByXPath(xpath), record);
    }

    public void setRecord(Element element, Map<String, String> record) throws InvalidDataException {
        for (Map.Entry<String, String> entry : record.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            try {
                this.setField(element, name, value);
            }
            catch (InvalidDataException e) {
                this.setAttribute(element, name, value);
            }
        }
    }

    public boolean isIdentical(Outcome other) {
        return Outcome.isIdentical(this.getDOM(), other.getDOM());
    }

    public static boolean isIdentical(Document origDocument, Document otherDOM) {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        Diff xmlDiff = new Diff(origDocument, otherDOM);
        if (!xmlDiff.identical()) {
            Logger.msg(xmlDiff.toString(), new Object[0]);
            return false;
        }
        return true;
    }

    public boolean hasField(String name) {
        return this.hasField(this.mDOM.getDocumentElement(), name);
    }

    public boolean hasField(Element element, String name) {
        return this.hasSingleField(element.getElementsByTagName(name));
    }

    public Integer getID() {
        return this.mID;
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public Document getDOM() {
        return this.mDOM;
    }

    public void setID(Integer mID) {
        this.mID = mID;
    }

    public void setSchema(Schema mSchema) {
        this.mSchema = mSchema;
    }

    public void setDOM(Document mDOM) {
        this.mDOM = mDOM;
    }

    static {
        XPATH_FACTORY = new ThreadLocal<XPathFactory>(){

            @Override
            protected XPathFactory initialValue() {
                return XPathFactory.newInstance();
            }
        };
        System.setProperty(DTM_MANAGER_NAME, DTM_MANAGER_VALUE);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(false);
        try {
            parser = dbf.newDocumentBuilder();
            Logger.msg(7, "Outcome static class init: " + parser.getClass().getName(), new Object[0]);
        }
        catch (ParserConfigurationException e) {
            Logger.error(e);
            Logger.die("Cannot function without XML parser", new Object[0]);
        }
    }
}

