/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.scripting;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.Include;
import org.cristalise.kernel.scripting.Parameter;
import org.cristalise.kernel.scripting.ParameterException;
import org.cristalise.kernel.scripting.ScriptParsingException;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.cristalise.kernel.utils.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Script
implements DescriptionObject {
    public static final String PARAMETER_AGENT = "agent";
    public static final String PARAMETER_DB = "db";
    public static final String PARAMETER_ITEM = "item";
    public static final String PARAMETER_JOB = "job";
    public static final String PARAMETER_LOCKER = "locker";
    public static final String PARAMETER_LOOKUP = "lookup";
    public static final String PARAMETER_OUTPUT = "output";
    public static final String PARAMETER_ORB = "orb";
    public static final String PARAMETER_PROXY = "proxy";
    public static final String PARAMETER_STORAGE = "storage";
    public static final String SYSTEM_USER = "system";
    String mScript = "";
    CompiledScript mCompScript = null;
    String mScriptXML = "";
    String mName;
    Integer mVersion;
    ItemPath mItemPath;
    String mLanguage;
    Map<String, Parameter> mInputParams = new HashMap<String, Parameter>();
    Map<String, Parameter> mOutputParams = new HashMap<String, Parameter>();
    Map<String, Parameter> mAllInputParams = new HashMap<String, Parameter>();
    ArrayList<Script> mIncludes = new ArrayList();
    ScriptEngine engine;
    ScriptContext context;
    boolean isActExecEnvironment = false;
    boolean lateBindIncluded = false;

    public Script() {
    }

    public Script(String name, Integer version, ItemPath path, String xml) throws ScriptParsingException, ParameterException {
        this(name, version, path, xml, false);
    }

    public Script(String name, Integer version, ItemPath path, String xml, boolean lateBind) throws ScriptParsingException, ParameterException {
        this.mName = name;
        this.mVersion = version;
        this.mItemPath = path;
        this.mScriptXML = xml;
        this.lateBindIncluded = lateBind;
        this.parseScriptXML(xml);
    }

    public Script(String lang, String expr, Class<?> returnType) throws ScriptingEngineException {
        this.mName = "<expr>";
        this.setScriptEngine(lang);
        this.mVersion = null;
        this.addOutput(null, returnType);
        this.setScriptData(expr);
    }

    public Script(String lang, String name, String expr, AgentProxy agent) throws ScriptingEngineException {
        this(lang, expr, Object.class);
        this.mName = name;
        this.addInputParam(PARAMETER_AGENT, AgentProxy.class);
        this.setInputParamValue(PARAMETER_AGENT, agent, true);
    }

    public Script(String lang, String expr) throws ScriptingEngineException {
        this(lang, expr, Object.class);
    }

    public Script(String lang, AgentProxy agent, PrintStream out) throws Exception {
        this.setScriptEngine(lang);
        Bindings beans = this.context.getBindings(100);
        beans.put(PARAMETER_STORAGE, (Object)Gateway.getStorage());
        beans.put(PARAMETER_DB, (Object)Gateway.getStorage().getDb());
        beans.put(PARAMETER_PROXY, (Object)Gateway.getProxyManager());
        beans.put(PARAMETER_LOOKUP, (Object)Gateway.getLookup());
        beans.put(PARAMETER_ORB, (Object)Gateway.getORB());
        beans.put(PARAMETER_AGENT, (Object)agent);
        beans.put(PARAMETER_OUTPUT, (Object)out);
        PrintWriter output = new PrintWriter(out);
        this.context.setWriter(output);
        this.context.setErrorWriter(output);
        String scriptText = Gateway.getResource().getTextResource(null, "textFiles/consoleScript." + lang + ".txt");
        try {
            Logger.msg(8, "Script() - Loaded consoleScript", new Object[0]);
            Logger.msg(8, scriptText, new Object[0]);
            this.engine.put("javax.script.filename", "consoleScript init script");
            this.engine.eval(scriptText);
        }
        catch (ScriptException ex) {
            ex.printStackTrace(out);
        }
        this.addOutput(null, Object.class);
    }

    private void setActExecEnvironment(ItemProxy object, AgentProxy subject, Job job) throws ScriptingEngineException, InvalidDataException {
        this.isActExecEnvironment = true;
        if (!this.mInputParams.containsKey(PARAMETER_ITEM)) {
            Logger.warning("Item param not declared in Script " + this.getName() + " v" + this.getVersion(), new Object[0]);
            this.addInputParam(PARAMETER_ITEM, ItemProxy.class);
        }
        this.setInputParamValue(PARAMETER_ITEM, object, true);
        if (!this.mInputParams.containsKey(PARAMETER_AGENT)) {
            Logger.warning("Agent param not declared in Script " + this.getName() + " v" + this.getVersion(), new Object[0]);
            this.addInputParam(PARAMETER_AGENT, AgentProxy.class);
        }
        this.setInputParamValue(PARAMETER_AGENT, subject, true);
        if (!this.mInputParams.containsKey(PARAMETER_JOB)) {
            Logger.warning("Job param not declared in Script " + this.getName() + " v" + this.getVersion(), new Object[0]);
            this.addInputParam(PARAMETER_JOB, Job.class);
        }
        this.setInputParamValue(PARAMETER_JOB, job, true);
        if (!this.mOutputParams.containsKey("errors")) {
            Logger.warning("Errors output not declared in Script " + this.getName() + " v" + this.getVersion(), new Object[0]);
            this.addOutput("errors", ErrorInfo.class);
        }
    }

    public void setScriptEngine(String requestedLang) throws ScriptingEngineException {
        String lang = Gateway.getProperties().getString("OverrideScriptLang." + requestedLang, requestedLang);
        ScriptEngineManager sem = (ScriptEngineManager)Gateway.getProperties().getObject("Script.EngineManager");
        if (sem == null) {
            sem = new ScriptEngineManager(this.getClass().getClassLoader());
        }
        this.engine = sem.getEngineByName(lang);
        if (this.engine == null) {
            throw new ScriptingEngineException("No script engine for '" + lang + "' found.");
        }
        this.mLanguage = requestedLang;
        this.createEmptyContext();
    }

    private void createEmptyContext() {
        this.context = new SimpleScriptContext();
        this.context.setBindings(this.engine.createBindings(), 100);
        this.engine.setContext(this.context);
    }

    public void setContext(ScriptContext context) {
        this.context = context;
        if (this.engine != null) {
            this.engine.setContext(context);
        }
    }

    public ScriptContext getContext() {
        return this.context;
    }

    private void parseScriptXML(String scriptXML) throws ScriptParsingException, ParameterException {
        if (StringUtils.isBlank((CharSequence)scriptXML)) {
            Logger.warning("Script.parseScriptXML - scriptXML was NULL!", new Object[0]);
            return;
        }
        Document scriptDoc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder domBuilder = factory.newDocumentBuilder();
            scriptDoc = domBuilder.parse(new InputSource(new StringReader(scriptXML)));
        }
        catch (Exception ex) {
            throw new ScriptParsingException("Error parsing Script XML", ex);
        }
        this.parseScriptTag(scriptDoc.getElementsByTagName("script"));
        this.parseIncludeTag(scriptDoc.getElementsByTagName("include"));
        this.parseParamTag(scriptDoc.getElementsByTagName("param"));
        this.parseOutputTag(scriptDoc.getElementsByTagName(PARAMETER_OUTPUT));
    }

    private void parseOutputTag(NodeList outputList) throws ScriptParsingException, ParameterException {
        for (int i = 0; i < outputList.getLength(); ++i) {
            Element output = (Element)outputList.item(i);
            if (!output.hasAttribute("type")) {
                throw new ScriptParsingException("Script Output declaration incomplete, must have type");
            }
            this.addOutput(output.getAttribute("name"), output.getAttribute("type"));
        }
    }

    private void parseParamTag(NodeList paramList) throws ScriptParsingException, ParameterException {
        for (int i = 0; i < paramList.getLength(); ++i) {
            Element param = (Element)paramList.item(i);
            if (!param.hasAttribute("name") || !param.hasAttribute("type")) {
                throw new ScriptParsingException("Script Input Param incomplete, must have name and type");
            }
            this.addInputParam(param.getAttribute("name"), param.getAttribute("type"));
        }
    }

    private void parseIncludeTag(NodeList includeList) throws ScriptParsingException {
        for (int i = 0; i < includeList.getLength(); ++i) {
            Element include = (Element)includeList.item(i);
            if (!include.hasAttribute("name") || !include.hasAttribute("version")) {
                throw new ScriptParsingException("Script include declaration incomplete, must have name and version");
            }
            String includeName = include.getAttribute("name");
            String includeVersion = include.getAttribute("version");
            try {
                Script includedScript = null;
                Integer includedVer = Integer.parseInt(includeVersion);
                includedScript = this.lateBindIncluded ? new Script(includeName, includedVer, null, null) : LocalObjectLoader.getScript(includeName, includedVer);
                includedScript.setContext(this.context);
                this.mIncludes.add(includedScript);
                for (Parameter includeParam : includedScript.getInputParams().values()) {
                    this.addIncludedInputParam(includeParam.getName(), includeParam.getType());
                }
                continue;
            }
            catch (NumberFormatException | InvalidDataException | ObjectNotFoundException | ScriptingEngineException e) {
                Logger.error(e);
                throw new ScriptParsingException("Included script '" + includeName + " v" + includeVersion + "' parse error", e);
            }
        }
    }

    private void parseScriptTag(NodeList scriptList) throws ScriptParsingException {
        Element scriptElem = (Element)scriptList.item(0);
        if (!scriptElem.hasAttribute("language")) {
            throw new ScriptParsingException("Script data incomplete, must specify scripting language");
        }
        Logger.msg(6, "Script.parseScriptTag() - Script Language: " + scriptElem.getAttribute("language"), new Object[0]);
        try {
            this.setScriptEngine(scriptElem.getAttribute("language"));
        }
        catch (ScriptingEngineException ex) {
            throw new ScriptParsingException(ex.getMessage(), ex);
        }
        NodeList scriptChildNodes = scriptElem.getChildNodes();
        if (scriptChildNodes.getLength() != 1) {
            throw new ScriptParsingException("More than one child element found under script tag. Script characters may need escaping - suggest convert to CDATA section");
        }
        if (!(scriptChildNodes.item(0) instanceof Text)) {
            throw new ScriptParsingException("Child element of script tag was not text");
        }
        this.setScriptData(((Text)scriptChildNodes.item(0)).getData());
        Logger.msg(6, "Script.parseScriptTag() - script:" + this.mScript, new Object[0]);
    }

    protected void addInputParam(String name, String type) throws ParameterException {
        try {
            this.addInputParam(name, Gateway.getResource().getClassForName(type));
        }
        catch (ClassNotFoundException ex) {
            throw new ParameterException("Input parameter " + name + " specifies class " + type + " which was not found.", ex);
        }
    }

    protected void addInputParam(String name, Class<?> type) throws ParameterException {
        Parameter inputParam = new Parameter(name, type);
        Logger.msg(6, "ScriptExecutor.addInputParam() - declared parameter " + name + " (" + type + ")", new Object[0]);
        this.mInputParams.put(inputParam.getName(), inputParam);
        this.mAllInputParams.put(inputParam.getName(), inputParam);
    }

    protected void addIncludedInputParam(String name, Class<?> type) throws ParameterException {
        if (this.mAllInputParams.containsKey(name)) {
            Parameter existingParam = this.mAllInputParams.get(name);
            if (existingParam.getType() == type) {
                return;
            }
            throw new ParameterException("Parameter conflict. Parameter'" + name + "' is declared as  " + existingParam.getType().getName() + " is declared in another script as " + type.getName());
        }
        Parameter inputParam = new Parameter(name);
        inputParam.setType(type);
        this.mAllInputParams.put(inputParam.getName(), inputParam);
    }

    protected void addOutput(String name, String type) throws ParameterException {
        try {
            this.addOutput(name, Gateway.getResource().getClassForName(type));
        }
        catch (ClassNotFoundException ex) {
            throw new ParameterException("Output parameter " + name + " specifies class " + type + " which was not found.", ex);
        }
    }

    protected void addOutput(String name, Class<?> type) throws ParameterException {
        if (this.mOutputParams.containsKey(name)) {
            throw new ParameterException("Output parameter '" + name + "' declared more than once.");
        }
        this.mOutputParams.put(name, new Parameter(name, type));
    }

    public boolean setInputParamValue(String name, Object value) throws ParameterException {
        return this.setInputParamValue(name, value, true);
    }

    public boolean setInputParamValue(String name, Object value, boolean overwrite) throws ParameterException {
        Parameter param = this.mInputParams.get(name);
        boolean wasUsed = false;
        if (!this.mAllInputParams.containsKey(name)) {
            return false;
        }
        if (param != null) {
            if (value != null && !param.getType().isInstance(value)) {
                throw new ParameterException("Parameter " + name + " in script " + this.mName + " v" + this.mVersion + " is wrong type \nRequired: " + param.getType().toString() + "\nSupplied: " + value.getClass().toString());
            }
            Bindings bindings = this.context.getBindings(100);
            if (!bindings.containsKey(name) || bindings.get(name) == null || overwrite && value != null) {
                bindings.put(name, value);
                Logger.msg(7, "Script.setInputParamValue() - " + name + ": " + value, new Object[0]);
                param.setInitialised(true);
                wasUsed = true;
            }
        }
        for (Script importScript : this.mIncludes) {
            wasUsed |= importScript.setInputParamValue(name, value, overwrite);
        }
        return wasUsed;
    }

    public Object evaluate(CastorHashMap inputProps) throws ScriptingEngineException {
        return this.evaluate(null, inputProps, null, false, null);
    }

    public Object evaluate(ItemPath itemPath, CastorHashMap inputProps, String actContext, Object locker) throws ScriptingEngineException {
        return this.evaluate(itemPath, inputProps, actContext, false, locker);
    }

    public synchronized Object evaluate(ItemPath itemPath, CastorHashMap inputProps, String actContext, boolean actExecEnv, Object locker) throws ScriptingEngineException {
        try {
            Object retVal;
            ItemProxy item = itemPath == null ? null : Gateway.getProxyManager().getProxy(itemPath);
            this.createEmptyContext();
            if (actExecEnv) {
                this.setActExecEnvironment(item, (AgentProxy)inputProps.get(PARAMETER_AGENT), (Job)inputProps.get(PARAMETER_JOB));
            }
            for (String inputParamName : this.getAllInputParams().keySet()) {
                if (!inputProps.containsKey(inputParamName)) continue;
                this.setInputParamValue(inputParamName, inputProps.evaluateProperty(itemPath, inputParamName, actContext, locker), true);
            }
            if (item != null) {
                item.setTransactionKey(locker);
            }
            if (this.getAllInputParams().containsKey(PARAMETER_ITEM) && this.getAllInputParams().get(PARAMETER_ITEM) != null) {
                this.setInputParamValue(PARAMETER_ITEM, item, true);
            }
            if (this.getAllInputParams().containsKey(PARAMETER_AGENT) && this.getAllInputParams().get(PARAMETER_AGENT) != null) {
                ItemProxy systemAgent = Gateway.getProxyManager().getProxy(Gateway.getLookup().getAgentPath(SYSTEM_USER));
                this.setInputParamValue(PARAMETER_AGENT, systemAgent, false);
            }
            if (this.getAllInputParams().containsKey(PARAMETER_LOCKER) && this.getAllInputParams().get(PARAMETER_LOCKER) != null) {
                this.setInputParamValue(PARAMETER_LOCKER, locker, true);
            }
            if ((retVal = this.execute()) == null) {
                retVal = "";
            }
            return retVal;
        }
        catch (Exception e) {
            Logger.error("Script.evaluate() - Script:" + this.getName(), new Object[0]);
            Logger.error(e);
            throw new ScriptingEngineException(e);
        }
    }

    public Object execute() throws ScriptingEngineException {
        this.executeIncludedScripts();
        StringBuffer missingParams = new StringBuffer();
        for (Parameter thisParam : this.mInputParams.values()) {
            if (thisParam.getInitialised()) continue;
            missingParams.append(thisParam.getName()).append("\n");
        }
        if (missingParams.length() > 0) {
            throw new ScriptingEngineException("Parameters were not set: \n" + missingParams.toString());
        }
        this.initOutputParams();
        Object returnValue = null;
        try {
            Logger.msg(7, "Script.execute() - Executing script:" + this.getName(), new Object[0]);
            if (Logger.doLog(8)) {
                Logger.msg("Script:\n" + this.mScript, new Object[0]);
            }
            if (this.engine == null) {
                throw new ScriptingEngineException("Script engine not set. Cannot execute scripts.");
            }
            this.engine.put("javax.script.filename", this.mName);
            returnValue = this.mCompScript != null ? this.mCompScript.eval(this.context) : this.engine.eval(this.mScript);
        }
        catch (ScriptException ex) {
            String msg = "Error executing script " + this.getName() + ": " + ex.getCause().getMessage();
            Logger.error(msg, new Object[0]);
            Logger.error(ex.getCause());
            throw new ScriptingEngineException(msg, ex.getCause());
        }
        return this.packScriptReturnValue(returnValue);
    }

    private void executeIncludedScripts() throws ScriptingEngineException {
        for (Script importScript : this.mIncludes) {
            Logger.msg(5, "Script.executeIncludedScripts() - name:" + importScript.getName() + " version:" + importScript.getVersion(), new Object[0]);
            if (this.isActExecEnvironment) {
                try {
                    importScript.setActExecEnvironment((ItemProxy)this.context.getAttribute(PARAMETER_ITEM), (AgentProxy)this.context.getAttribute(PARAMETER_AGENT), (Job)this.context.getAttribute(PARAMETER_JOB));
                }
                catch (InvalidDataException e) {
                    Logger.error(e);
                    throw new ScriptingEngineException(e);
                }
            }
            importScript.setContext(this.context);
            Object output = importScript.execute();
            if (output == null || !(output instanceof Map)) continue;
            ((Map)output).forEach((outputKey, outputValue) -> {
                if (this.mInputParams.containsKey(outputKey)) {
                    try {
                        Logger.msg(5, "Script.executeIncludedScripts() - setting inputs for parameter:" + outputKey, new Object[0]);
                        this.setInputParamValue((String)outputKey, outputValue, true);
                    }
                    catch (ParameterException e) {
                        Logger.error(e);
                    }
                }
            });
        }
    }

    private void initOutputParams() {
        for (Parameter outputParam : this.mOutputParams.values()) {
            if (StringUtils.isBlank((CharSequence)outputParam.getName())) continue;
            Logger.msg(8, "Script.initOutputParams() - Initialising output bean '" + outputParam.getName() + "'", new Object[0]);
            Object emptyObject = null;
            try {
                emptyObject = outputParam.getType().newInstance();
            }
            catch (Exception e) {
                Logger.warning("Script.initOutputParams() - Failed to init output:%s error:%s", outputParam.getName(), e.getMessage());
            }
            this.context.getBindings(100).put(outputParam.getName(), (Object)emptyObject);
        }
    }

    private Object packScriptReturnValue(Object returnValue) throws ScriptingEngineException {
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        if (this.mOutputParams.size() == 0) {
            if (returnValue != null) {
                Logger.warning("Script.packScriptReturnValue(" + this.getName() + ") - No output params defined, returnValue is NOT null but it is discarded", new Object[0]);
            } else {
                Logger.msg(4, "Script.packScriptReturnValue(" + this.getName() + ") - No output params defined. Returning null.", new Object[0]);
            }
            return null;
        }
        if (this.mOutputParams.size() == 1) {
            Parameter outputParam = this.mOutputParams.values().iterator().next();
            String outputName = outputParam.getName();
            if (StringUtils.isBlank((CharSequence)outputName)) {
                if (returnValue != null && !outputParam.getType().isInstance(returnValue)) {
                    throw new ScriptingEngineException("Script returnValue was not instance of " + outputParam.getType().getName());
                }
                return returnValue;
            }
            Object output = this.context.getBindings(100).get(outputParam.getName());
            if (output == null) {
                if (!outputName.equals("errors")) {
                    Logger.msg(5, "Script.packScriptReturnValue(" + this.getName() + ") - assigning script returnValue to named output '" + outputName + "'", new Object[0]);
                    if (returnValue != null && !outputParam.getType().isInstance(returnValue)) {
                        throw new ScriptingEngineException("Script returnValue was not instance of " + outputParam.getType().getName());
                    }
                    output = returnValue;
                } else {
                    Logger.msg(5, "Script.packScriptReturnValue(" + this.getName() + ") - return value for 'errors' is discarded", new Object[0]);
                }
            } else if (!outputParam.getType().isInstance(output)) {
                throw new ScriptingEngineException("Script '" + this.getName() + "' returnValue was not instance of " + outputParam.getType().getName());
            }
            outputs.put(outputName, output);
            return outputs;
        }
        if (returnValue != null) {
            Logger.msg(5, "Script.packScriptReturnValue() - returnValue is NOT null but it is discarded", new Object[0]);
        }
        for (Parameter outputParam : this.mOutputParams.values()) {
            String outputName = outputParam.getName();
            if (StringUtils.isBlank((CharSequence)outputName)) {
                throw new ScriptingEngineException("Script " + this.getName() + " - All outputs must have a name.");
            }
            Object outputValue = this.context.getBindings(100).get(outputParam.getName());
            Logger.msg(4, "Script.packScriptReturnValue(" + this.getName() + ") - Output " + outputName + "=" + (outputValue == null ? "null" : outputValue.toString()), new Object[0]);
            if (outputValue != null && !outputParam.getType().isInstance(outputValue)) {
                throw new ScriptingEngineException("Script '" + this.getName() + "' output '" + outputName + "' was not null and it was not instance of " + outputParam.getType().getName() + ", it was a " + outputValue.getClass().getName());
            }
            outputs.put(outputParam.getName(), outputValue);
        }
        return outputs;
    }

    public void setScriptData(String script) throws ScriptParsingException {
        this.mScript = script;
        if (this.engine instanceof Compilable) {
            try {
                Logger.msg(1, "Script.setScriptData() - Compiling script " + this.mName, new Object[0]);
                this.engine.put("javax.script.filename", this.mName);
                this.mCompScript = ((Compilable)((Object)this.engine)).compile(this.mScript);
            }
            catch (ScriptException e) {
                Logger.error(e);
                throw new ScriptParsingException(e);
            }
        }
    }

    public String getScriptData() {
        return this.mScriptXML;
    }

    @Override
    public String getItemID() {
        if (this.mItemPath == null || this.mItemPath.getUUID() == null) {
            return "";
        }
        return this.mItemPath.getUUID().toString();
    }

    public static Script getScript(String name, Integer version) throws ScriptingEngineException, ObjectNotFoundException, InvalidDataException {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ScriptingEngineException("Script name is blank");
        }
        if (version != null) {
            return LocalObjectLoader.getScript(name, version);
        }
        String[] tokens = name.split(":");
        if (tokens.length == 2) {
            return new Script(tokens[0], tokens[1]);
        }
        throw new InvalidDataException("Data '" + name + "' cannot be interpreted as expression");
    }

    public ArrayList<Include> getIncludes() {
        ArrayList<Include> returnList = new ArrayList<Include>();
        for (Script s : this.mIncludes) {
            returnList.add(new Include(s.getName(), s.getVersion()));
        }
        return returnList;
    }

    public void setIncludes(ArrayList<Include> includes) throws ObjectNotFoundException, InvalidDataException, ParameterException, ScriptParsingException {
        for (Include i : includes) {
            Script includedScript = new Script(i.name, i.version, null, null);
            includedScript.setContext(this.context);
            this.mIncludes.add(includedScript);
            for (Parameter includeParam : includedScript.getInputParams().values()) {
                this.addIncludedInputParam(includeParam.getName(), includeParam.getType());
            }
        }
    }

    @Override
    public CollectionArrayList makeDescCollections() throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = new CollectionArrayList();
        Dependency includeColl = new Dependency(BuiltInCollections.INCLUDE);
        for (Script script : this.mIncludes) {
            try {
                includeColl.addMember(script.getItemPath());
            }
            catch (InvalidCollectionModification e) {
                Logger.error(e);
                throw new InvalidDataException("Could not add " + script.getName() + " to description collection. " + e.getMessage());
            }
            catch (ObjectAlreadyExistsException e) {
                Logger.error(e);
                throw new InvalidDataException("Script " + script.getName() + " included more than once.");
            }
        }
        retArr.put(includeColl);
        return retArr;
    }

    @Override
    public void export(Writer imports, File dir, boolean shallow) throws IOException {
        String tc = BuiltInResources.SCRIPT_RESOURCE.getTypeCode();
        FileStringUtility.string2File(new File(new File(dir, tc), this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), this.getScriptData());
        if (imports == null) {
            return;
        }
        if (Gateway.getProperties().getBoolean("Resource.useOldImportFormat", false)) {
            imports.write("<Resource name='" + this.getName() + "' " + (this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (this.getVersion() == null ? "" : "version='" + this.getVersion() + "' ") + "type='" + tc + "'>boot/" + tc + "/" + this.getName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml</Resource>\n");
        } else {
            imports.write("<ScriptResource name='" + this.getName() + "' " + (this.getItemPath() == null ? "" : "id='" + this.getItemID() + "' ") + (this.getVersion() == null ? "" : "version='" + this.getVersion() + "'") + "/>\n");
        }
    }

    public static void main(String[] args) {
        for (ScriptEngineFactory sef : new ScriptEngineManager().getEngineFactories()) {
            System.out.println(sef.getEngineName() + " v" + sef.getEngineVersion() + " using " + sef.getLanguageName() + " v" + sef.getLanguageVersion() + " " + sef.getNames());
        }
        System.out.println("Preferred javascript engine: " + new ScriptEngineManager().getEngineByName("javascript").getClass().getName());
    }

    public String getScript() {
        return this.mScript;
    }

    public CompiledScript getCompScript() {
        return this.mCompScript;
    }

    public String getScriptXML() {
        return this.mScriptXML;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public Integer getVersion() {
        return this.mVersion;
    }

    @Override
    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public Map<String, Parameter> getInputParams() {
        return this.mInputParams;
    }

    public Map<String, Parameter> getOutputParams() {
        return this.mOutputParams;
    }

    public Map<String, Parameter> getAllInputParams() {
        return this.mAllInputParams;
    }

    public void setScript(String mScript) {
        this.mScript = mScript;
    }

    public void setCompScript(CompiledScript mCompScript) {
        this.mCompScript = mCompScript;
    }

    public void setScriptXML(String mScriptXML) {
        this.mScriptXML = mScriptXML;
    }

    @Override
    public void setName(String mName) {
        this.mName = mName;
    }

    @Override
    public void setVersion(Integer mVersion) {
        this.mVersion = mVersion;
    }

    @Override
    public void setItemPath(ItemPath mItemPath) {
        this.mItemPath = mItemPath;
    }

    public void setLanguage(String mLanguage) {
        this.mLanguage = mLanguage;
    }

    public void setInputParams(Map<String, Parameter> mInputParams) {
        this.mInputParams = mInputParams;
    }

    public void setOutputParams(Map<String, Parameter> mOutputParams) {
        this.mOutputParams = mOutputParams;
    }

    public void setAllInputParams(Map<String, Parameter> mAllInputParams) {
        this.mAllInputParams = mAllInputParams;
    }
}

