/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.utils.DescriptionObjectCache;
import org.cristalise.kernel.utils.Logger;

public class ActDefCache
extends DescriptionObjectCache<ActivityDef> {
    Boolean isComposite = null;

    public ActDefCache(Boolean isComposite) {
        this.isComposite = isComposite;
    }

    @Override
    public String getTypeCode() {
        if (this.isComposite == null) {
            return BuiltInResources.ACTIVITY_DESC_RESOURCE.getTypeCode();
        }
        return this.isComposite != false ? BuiltInResources.COMP_ACT_DESC_RESOURCE.getTypeCode() : BuiltInResources.ELEM_ACT_DESC_RESOURCE.getTypeCode();
    }

    @Override
    public String getSchemaName() {
        if (this.isComposite == null) {
            return BuiltInResources.ACTIVITY_DESC_RESOURCE.getSchemaName();
        }
        return this.isComposite != false ? BuiltInResources.COMP_ACT_DESC_RESOURCE.getSchemaName() : BuiltInResources.ELEM_ACT_DESC_RESOURCE.getSchemaName();
    }

    @Override
    protected boolean isBootResource(String filename, String resName) {
        if (this.isComposite == null) {
            return filename.endsWith("/" + resName) && (filename.startsWith("CA") || filename.startsWith("EA"));
        }
        return super.isBootResource(filename, resName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ActivityDef loadObject(String name, int version, ItemProxy proxy) throws ObjectNotFoundException, InvalidDataException {
        String viewName;
        if (this.isComposite == null) {
            String prop = proxy.getProperty(BuiltInItemProperties.COMPLEXITY);
            if ("Composite".equals(prop)) {
                viewName = BuiltInResources.COMP_ACT_DESC_RESOURCE.getSchemaName();
            } else {
                if (!"Elementary".equals(prop)) throw new InvalidDataException("Missing Item property:" + (Object)((Object)BuiltInItemProperties.COMPLEXITY));
                viewName = BuiltInResources.ELEM_ACT_DESC_RESOURCE.getSchemaName();
            }
        } else {
            viewName = this.isComposite != false ? BuiltInResources.COMP_ACT_DESC_RESOURCE.getSchemaName() : BuiltInResources.ELEM_ACT_DESC_RESOURCE.getSchemaName();
        }
        try {
            Viewpoint actView = (Viewpoint)proxy.getObject((Object)((Object)ClusterType.VIEWPOINT) + "/" + viewName + "/" + version);
            String marshalledAct = actView.getOutcome().getData();
            return this.buildObject(name, version, proxy.getPath(), marshalledAct);
        }
        catch (PersistencyException ex) {
            Logger.error(ex);
            throw new ObjectNotFoundException("Problem loading Activity " + name + " v" + version + ": " + ex.getMessage());
        }
    }

    @Override
    public ActivityDef buildObject(String name, int version, ItemPath path, String data) throws InvalidDataException {
        try {
            ActivityDef thisActDef = (ActivityDef)Gateway.getMarshaller().unmarshall(data);
            thisActDef.setBuiltInProperty(BuiltInVertexProperties.VERSION, version);
            thisActDef.setName(name);
            thisActDef.setVersion(version);
            thisActDef.setItemPath(path);
            return thisActDef;
        }
        catch (Exception ex) {
            Logger.error(ex);
            throw new InvalidDataException("Could not unmarshall Activity '" + name + "' v" + version + ": " + ex.getMessage());
        }
    }
}

