/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationInstance;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.collection.CollectionDescription;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationDescription
extends Aggregation
implements CollectionDescription<AggregationMember> {
    private static final Logger log = LoggerFactory.getLogger(AggregationDescription.class);

    public AggregationDescription() {
        this.setName("AggregationDescription");
    }

    public AggregationDescription(String name) {
        this.setName(name);
    }

    public AggregationDescription(String name, Integer version) {
        this.setName(name);
        this.setVersion(version);
    }

    public Aggregation newInstance() throws ObjectNotFoundException {
        AggregationInstance newInstance = new AggregationInstance(this.getName());
        for (int i = 0; i < this.size(); ++i) {
            AggregationMember mem = (AggregationMember)this.mMembers.list.get(i);
            String descVer = this.getDescVer(mem);
            PropertyDescriptionList pdList = PropertyUtility.getPropertyDescriptionOutcome(mem.getItemPath(), descVer, null);
            if (pdList != null) {
                try {
                    Vertex v = this.getLayout().getVertexById(mem.getID());
                    newInstance.addMember(null, PropertyUtility.convertTransitiveProperties(pdList), pdList.getClassProps(), v.getCentrePoint(), v.getWidth(), v.getHeight());
                }
                catch (InvalidCollectionModification invalidCollectionModification) {
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {}
                continue;
            }
            log.error("newInstance() There is no PropertyDescription. Cannot instantiate. " + mem.getItemPath());
            return null;
        }
        return newInstance;
    }
}

