/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.transfer;

import java.io.File;
import java.util.ArrayList;
import org.cristalise.kernel.entity.transfer.TransferItem;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.FileStringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferSet {
    private static final Logger log = LoggerFactory.getLogger(TransferSet.class);
    public ArrayList<TransferItem> items;

    public TransferSet() {
    }

    public TransferSet(ItemPath[] itemPaths) {
        this.items = new ArrayList();
        for (ItemPath item : itemPaths) {
            try {
                this.items.add(new TransferItem(item));
            }
            catch (Exception ex) {
                log.error("Could not add item " + item, (Throwable)ex);
            }
        }
    }

    public void exportPackage(File dir) throws Exception {
        if (this.items == null || this.items.size() == 0) {
            throw new Exception("Nothing to dump");
        }
        FileStringUtility.createNewDir(dir.getAbsolutePath());
        for (TransferItem element : this.items) {
            try {
                element.exportItem(new File(dir, element.itemPath.getUUID().toString()), "/");
            }
            catch (Exception ex) {
                log.error("Error dumping item " + element.itemPath, (Throwable)ex);
            }
        }
        try {
            String self = Gateway.getMarshaller().marshall(this);
            FileStringUtility.string2File(new File(dir, "transferSet.xml"), self);
        }
        catch (Exception ex) {
            log.error("Error writing header file", (Throwable)ex);
        }
    }

    public void importPackage(File rootDir) {
        for (TransferItem element : this.items) {
            log.info("Importing " + element.itemPath);
            try {
                element.importItem(new File(rootDir, element.itemPath.getUUID().toString()));
            }
            catch (Exception ex) {
                log.error("Import of item " + element.itemPath + " failed. Rolling back", (Object)log);
                Gateway.getStorage().abort(element);
            }
        }
    }
}

