/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.collection;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyMember
implements CollectionMember {
    private static final Logger log = LoggerFactory.getLogger(DependencyMember.class);
    private ItemPath mItemPath = null;
    private ItemProxy mItem = null;
    private int mId = -1;
    private CastorHashMap mProperties = new CastorHashMap();
    private String mClassProps = "";

    @Override
    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    public void setProperties(CastorHashMap props) {
        this.mProperties = props;
    }

    @Override
    public CastorHashMap getProperties() {
        return this.mProperties;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.mProperties.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.mProperties.setKeyValuePairs(pairs);
    }

    @Override
    public int getID() {
        return this.mId;
    }

    public void setID(int id) {
        this.mId = id;
    }

    public void setClassProps(String props) {
        this.mClassProps = props;
    }

    @Override
    public String getClassProps() {
        return this.mClassProps;
    }

    @Override
    public void assignItem(ItemPath itemPath) throws InvalidCollectionModification {
        if (itemPath != null) {
            if (this.mClassProps == null || this.getProperties() == null) {
                throw new InvalidCollectionModification("ClassProps not yet set. Cannot check membership validity.");
            }
            StringTokenizer sub = new StringTokenizer(this.mClassProps, ",");
            while (sub.hasMoreTokens()) {
                String aClassProp = sub.nextToken();
                try {
                    String memberValue = (String)this.getProperties().get(aClassProp);
                    Property itemProperty = (Property)Gateway.getStorage().get(itemPath, (Object)((Object)ClusterType.PROPERTY) + "/" + aClassProp, null);
                    if (itemProperty == null) {
                        throw new InvalidCollectionModification("Property " + aClassProp + " does not exist for item " + itemPath);
                    }
                    if (itemProperty.getValue().equalsIgnoreCase(memberValue)) continue;
                    throw new InvalidCollectionModification("checkProperty() Values of mandatory prop " + aClassProp + " do not match " + itemProperty.getValue() + "!=" + memberValue);
                }
                catch (Exception ex) {
                    log.error("", (Throwable)ex);
                    throw new InvalidCollectionModification("Error checking properties");
                }
            }
        }
        this.mItemPath = itemPath;
        this.mItem = null;
    }

    @Override
    public void clearItem() {
        this.mItemPath = null;
        this.mItem = null;
    }

    @Override
    public ItemProxy resolveItem() throws ObjectNotFoundException {
        if (this.mItem == null && this.mItemPath != null) {
            this.mItem = Gateway.getProxyManager().getProxy(this.mItemPath);
        }
        return this.mItem;
    }

    public void setChildUUID(String uuid) throws InvalidCollectionModification, InvalidItemPathException {
        this.mItemPath = new ItemPath(uuid);
    }

    @Override
    public String getChildUUID() {
        return this.mItemPath.getUUID().toString();
    }

    public Object getBuiltInProperty(BuiltInVertexProperties prop) {
        return this.mProperties.get(prop.getName());
    }

    public void setBuiltInProperty(BuiltInVertexProperties prop, Object val) {
        this.mProperties.put(prop.getName(), val);
    }

    protected Object evaluateScript() throws InvalidDataException, ObjectNotFoundException {
        log.debug("evaluateScript() - memberUUID:" + this.getChildUUID());
        Script script = LocalObjectLoader.getScript(this.getProperties());
        try {
            script.setInputParamValue("dependencyMember", this);
            script.setInputParamValue("storage", Gateway.getStorage());
            script.setInputParamValue("proxy", Gateway.getProxyManager());
            script.setInputParamValue("lookup", Gateway.getLookup());
            return script.evaluate(this.getItemPath(), this.getProperties(), null, null);
        }
        catch (ScriptingEngineException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public void updatePropertieFromDescription(CastorHashMap propDesc, DependencyMember newMember) throws ObjectNotFoundException, InvalidCollectionModification {
        for (String key : propDesc.keySet()) {
            Object newValue = newMember != null ? (Object)newMember.mProperties.get(key) : null;
            Object newDefaultValue = propDesc.get(key);
            if (this.mProperties.containsKey(key)) {
                if (this.mClassProps.contains(key)) {
                    this.mProperties.put(key, newDefaultValue);
                    continue;
                }
                if (newValue == null) continue;
                this.mProperties.put(key, newValue);
                continue;
            }
            if (this.mClassProps.contains(key)) {
                this.mProperties.put(key, newDefaultValue);
                continue;
            }
            this.mProperties.put(key, newValue != null ? newValue : (Object)newDefaultValue);
        }
        Iterator propsNames = this.mProperties.keySet().iterator();
        while (propsNames.hasNext()) {
            String key;
            key = (String)propsNames.next();
            if (propDesc.containsKey(key)) continue;
            propsNames.remove();
        }
    }

    public void updateProperties(CastorHashMap newProps) throws ObjectNotFoundException, InvalidCollectionModification {
        for (Map.Entry newProp : newProps.entrySet()) {
            if (this.mClassProps.contains((CharSequence)newProp.getKey())) {
                throw new InvalidCollectionModification("Dependency cannot change classProperties:" + this.mClassProps);
            }
            if (this.getProperties().containsKey(newProp.getKey())) {
                this.getProperties().put(newProp.getKey(), newProp.getValue());
                continue;
            }
            throw new ObjectNotFoundException("Property " + (String)newProp.getKey() + " does not exists for slotID:" + this.getID());
        }
    }

    public boolean convertToItemPropertyByScript(PropertyArrayList props) throws InvalidDataException, ObjectNotFoundException {
        log.debug("convertToItemPropertyByScript() - memberUUID:" + this.getChildUUID());
        String scriptName = (String)this.getBuiltInProperty(BuiltInVertexProperties.SCRIPT_NAME);
        if (scriptName != null && scriptName.length() > 0) {
            Object result = this.evaluateScript();
            if (result != null && result instanceof PropertyArrayList) {
                props.merge((PropertyArrayList)result);
                return true;
            }
            throw new InvalidDataException("Script '" + scriptName + "' returned null or the wrong type");
        }
        return false;
    }
}

