/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignItemToSlot
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(AssignItemToSlot.class);

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectCannotBeUpdated, InvalidCollectionModification {
        C2KLocalObject collObj;
        ItemPath childItem;
        int slotNo;
        String collName;
        Object[] params = AssignItemToSlot.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(), item, params});
        try {
            collName = params[0];
            slotNo = Integer.parseInt(params[1]);
            try {
                childItem = new ItemPath((String)params[2]);
            }
            catch (InvalidItemPathException e) {
                childItem = new DomainPath((String)params[2]).getItemPath();
            }
        }
        catch (Exception e) {
            log.error("Invalid parameters " + Arrays.toString(params), (Throwable)e);
            throw new InvalidDataException("AssignItemToSlot: Invalid parameters " + Arrays.toString(params));
        }
        try {
            collObj = Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/last", locker);
        }
        catch (PersistencyException ex) {
            log.error("Error loading collection '" + collName + "'", (Throwable)ex);
            throw new PersistencyException("AssignItemToSlot: Error loading collection '" + collName + "': " + ex.getMessage());
        }
        if (!(collObj instanceof Aggregation)) {
            throw new InvalidDataException("AssignItemToSlot: AssignItemToSlot operates on Aggregation collections only.");
        }
        Aggregation agg = (Aggregation)collObj;
        boolean stored = false;
        for (AggregationMember member : agg.getMembers().list) {
            if (member.getID() != slotNo) continue;
            if (member.getItemPath() != null) {
                throw new ObjectCannotBeUpdated("AssignItemToSlot: Member slot " + slotNo + " not empty");
            }
            member.assignItem(childItem);
            stored = true;
            break;
        }
        if (!stored) {
            throw new ObjectNotFoundException("AssignItemToSlot: Member slot " + slotNo + " not found.");
        }
        try {
            Gateway.getStorage().put(item, agg, locker);
        }
        catch (PersistencyException e) {
            throw new PersistencyException("AssignItemToSlot: Error saving collection '" + collName + "': " + e.getMessage());
        }
        return requestData;
    }
}

