/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.agent;

import java.util.ArrayList;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAgentRoles
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(SetAgentRoles.class);

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException {
        AgentPath targetAgent;
        String[] params = SetAgentRoles.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(), item, params});
        try {
            targetAgent = new AgentPath(item);
        }
        catch (InvalidItemPathException ex) {
            throw new InvalidDataException("Could not resolve syskey " + item + " as an Agent.");
        }
        RolePath[] currentRoles = targetAgent.getRoles();
        ArrayList<RolePath> requestedRoles = new ArrayList<RolePath>();
        for (int i = 0; i < params.length; ++i) {
            try {
                requestedRoles.add(Gateway.getLookup().getRolePath(params[i]));
                continue;
            }
            catch (ObjectNotFoundException e) {
                throw new InvalidDataException("Role " + params[i] + " not found");
            }
        }
        ArrayList<RolePath> rolesToRemove = new ArrayList<RolePath>();
        for (RolePath existingRole : currentRoles) {
            if (requestedRoles.contains(existingRole)) {
                requestedRoles.remove(existingRole);
                continue;
            }
            rolesToRemove.add(existingRole);
        }
        for (RolePath roleToRemove : rolesToRemove) {
            try {
                Gateway.getLookupManager().removeRole(targetAgent, roleToRemove);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new InvalidDataException("Error removing role " + roleToRemove.getName());
            }
        }
        for (RolePath roleToAdd : requestedRoles) {
            try {
                Gateway.getLookupManager().addRole(targetAgent, roleToAdd);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new InvalidDataException("Error adding role " + roleToAdd.getName());
            }
        }
        return requestData;
    }
}

