/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.io.IOException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportAgent;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewAgent
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(CreateNewAgent.class);

    public CreateNewAgent() {
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, "Agent");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException {
        try {
            ImportAgent newAgent = (ImportAgent)Gateway.getMarshaller().unmarshall(requestData);
            newAgent.create(agent, true);
            newAgent.setPassword("REDACTED");
            return Gateway.getMarshaller().marshall(newAgent);
        }
        catch (IOException | MappingException | MarshalException | ValidationException e) {
            log.error("Couldn't unmarshall new Agent: " + requestData, e);
            throw new InvalidDataException("CreateNewAgent: Couldn't unmarshall new Agent: " + requestData);
        }
    }
}

