/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.Agent;
import org.cristalise.kernel.entity.AgentHelper;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JobPusher
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(JobPusher.class);
    private final Activity activity;
    private final RolePath myRole;
    private final ItemPath itemPath;

    JobPusher(Activity activity, ItemPath itemPath, RolePath role) {
        this.activity = activity;
        this.itemPath = itemPath;
        this.myRole = role;
    }

    @Override
    public void run() {
        String tName = "Agent job pusher for " + this.itemPath + ":" + this.activity.getPath() + " to role " + this.myRole;
        Thread.currentThread().setName(tName);
        log.trace("run() - Started:" + tName);
        try {
            for (AgentPath nextAgent : Gateway.getLookup().getAgents(this.myRole)) {
                log.trace("run() - Calculating jobs for agent:" + nextAgent);
                try {
                    JobArrayList jobList = new JobArrayList(this.activity.calculateJobs(nextAgent, this.itemPath, false));
                    String stringJobs = Gateway.getMarshaller().marshall(jobList);
                    Agent thisAgent = AgentHelper.narrow((Object)nextAgent.getIOR());
                    log.trace("run() - Calling refreshJobList() with " + jobList.list.size() + " jobs for agent " + nextAgent + " from " + this.activity.getPath());
                    thisAgent.refreshJobList(this.itemPath.getSystemKey(), this.activity.getPath(), stringJobs);
                }
                catch (Exception ex) {
                    log.error("run() - Agent " + nextAgent + " of role " + this.myRole + " could not be found to be informed of a change in " + this.itemPath, (Throwable)ex);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            log.warn("Cannot push jobs, it did not find any agents for role:" + this.myRole);
        }
        log.trace("run() - FINISHED:" + tName);
    }
}

