/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.BuiltInEdgeProperties;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableEdge;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lifecycle.instance.WfVertex;

public class Next
extends GraphableEdge {
    public Next() {
    }

    public Next(WfVertex pre, WfVertex nex) {
        super(pre, nex);
        this.setBuiltInProperty(BuiltInEdgeProperties.ALIAS, "");
        this.setBuiltInProperty(BuiltInEdgeProperties.TYPE, "Straight");
    }

    public boolean verify() {
        return true;
    }

    public WfVertex getTerminusVertex() throws InvalidDataException {
        for (GraphableVertex v : this.getParent().getChildren()) {
            if (v.getID() != this.getTerminusVertexId()) continue;
            return (WfVertex)v;
        }
        throw new InvalidDataException("Terminus Vertex Id:" + this.getTerminusVertexId() + " was not found in parent:" + this.getParent().getName());
    }

    @Override
    public boolean containsPoint(GraphPoint p) {
        boolean arrowOnY;
        GraphPoint originPoint = this.getOriginPoint();
        GraphPoint terminusPoint = this.getTerminusPoint();
        GraphPoint midPoint = new GraphPoint();
        if ("Broken +".equals(this.getBuiltInProperty(BuiltInEdgeProperties.TYPE))) {
            midPoint.x = (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = (originPoint.y + terminusPoint.y) / 2;
        } else if ("Broken -".equals(this.getBuiltInProperty(BuiltInEdgeProperties.TYPE))) {
            arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
            midPoint.x = arrowOnY ? terminusPoint.x : (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : originPoint.y;
        } else if ("Broken |".equals(this.getBuiltInProperty(BuiltInEdgeProperties.TYPE))) {
            arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
            midPoint.x = arrowOnY ? originPoint.x : (originPoint.x + terminusPoint.x) / 2;
            midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : terminusPoint.y;
        } else {
            midPoint.x = originPoint.x + (terminusPoint.x - originPoint.x) / 2;
            midPoint.y = originPoint.y + (terminusPoint.y - originPoint.y) / 2;
        }
        int minX = midPoint.x - 10;
        int minY = midPoint.y - 10;
        int maxX = midPoint.x + 10;
        int maxY = midPoint.y + 10;
        return p.x >= minX && p.x <= maxX && p.y >= minY && p.y <= maxY;
    }
}

