/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.PropertyUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeName
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(ChangeName.class);
    public static final String description = "Removes Items old Name, add the new Name and changes the Name property";

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectCannotBeUpdated, ObjectAlreadyExistsException, CannotManageException, ObjectNotFoundException {
        Object[] params = ChangeName.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(), item, params});
        if (params.length != 2) {
            throw new InvalidDataException("ChangeName: Invalid parameters: " + Arrays.toString(params));
        }
        String oldName = params[0];
        String newName = params[1];
        log.info("oldName:{} newName:{}", (Object)oldName, (Object)newName);
        if (oldName.equals(newName)) {
            log.info("oldName:{} == newName:{} - NOTHING DONE", (Object)oldName, (Object)newName);
            return requestData;
        }
        String currentNameProp = PropertyUtility.getProperty(item, BuiltInItemProperties.NAME, locker).getValue();
        if (!oldName.equals(currentNameProp)) {
            throw new InvalidDataException(item + " current Name propety '" + currentNameProp + "' is different from old name '" + oldName + "'");
        }
        Lookup.PagedResult result = Gateway.getLookup().searchAliases(item, 0, 100);
        DomainPath currentDP = null;
        DomainPath newDP = null;
        if (result.rows.size() > 0) {
            for (Path path : result.rows) {
                if (!path.getName().equals(oldName)) continue;
                currentDP = (DomainPath)path;
                break;
            }
            if (currentDP == null) {
                throw new InvalidDataException(item + " does not domainPath with name:" + oldName);
            }
            newDP = this.changeDomianPath(item, newName, currentDP, locker);
        }
        try {
            PropertyUtility.writeProperty(item, BuiltInItemProperties.NAME, newName, locker);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            if (newDP != null) {
                Gateway.getLookupManager().delete(newDP);
                Gateway.getLookupManager().add(currentDP);
            }
            throw new CannotManageException(e.getMessage());
        }
        return requestData;
    }

    private DomainPath changeDomianPath(ItemPath item, String newName, DomainPath currentDP, Object locker) throws ObjectCannotBeUpdated, ObjectAlreadyExistsException, CannotManageException {
        DomainPath rootDP = currentDP.getParent();
        DomainPath newDP = new DomainPath(rootDP, newName);
        newDP.setItemPath(item);
        Gateway.getLookupManager().add(newDP);
        try {
            Gateway.getLookupManager().delete(currentDP);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            Gateway.getLookupManager().delete(newDP);
            throw new CannotManageException(e.getMessage());
        }
        return newDP;
    }
}

