/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.renderer.DefaultVertexRenderer;
import org.cristalise.kernel.lifecycle.AndSplitDef;
import org.cristalise.kernel.lifecycle.JoinDef;
import org.cristalise.kernel.lifecycle.LoopDef;
import org.cristalise.kernel.lifecycle.OrSplitDef;
import org.cristalise.kernel.lifecycle.XOrSplitDef;
import org.cristalise.kernel.lifecycle.instance.AndSplit;
import org.cristalise.kernel.lifecycle.instance.Join;
import org.cristalise.kernel.lifecycle.instance.Loop;
import org.cristalise.kernel.lifecycle.instance.OrSplit;
import org.cristalise.kernel.lifecycle.instance.XOrSplit;

public class DefaultSplitJoinRenderer
extends DefaultVertexRenderer {
    public static final Paint BOX_PAINT = new Color(204, 204, 204);
    private static final String AND_LABEL = "And";
    private static final String OR_LABEL = "Or";
    private static final String XOR_LABEL = "XOr";
    private static final String JOIN_LABEL = "Join";
    private static final String LOOP_LABEL = "Loop";
    private static final String ROUTE_LABEL = "";
    private static final String XXX_LABEL = "XXX";

    public void draw(Graphics2D g2d, Vertex vertex, String errors) {
        this.drawOutlineRect(g2d, vertex, StringUtils.isNotBlank((CharSequence)errors) ? ERROR_PAINT : BOX_PAINT, TEXT_PAINT);
        ArrayList<String> linesOfText = new ArrayList<String>();
        linesOfText.add(this.getLabel(vertex));
        if (StringUtils.isNotBlank((CharSequence)errors)) {
            linesOfText.add(errors);
        }
        this.drawLinesOfTexts(g2d, vertex, linesOfText, TEXT_PAINT);
    }

    private String getLabel(Vertex vertex) {
        if (vertex instanceof Loop || vertex instanceof LoopDef) {
            return LOOP_LABEL;
        }
        if (vertex instanceof XOrSplit || vertex instanceof XOrSplitDef) {
            return XOR_LABEL;
        }
        if (vertex instanceof OrSplit || vertex instanceof OrSplitDef) {
            return OR_LABEL;
        }
        if (vertex instanceof AndSplit || vertex instanceof AndSplitDef) {
            return AND_LABEL;
        }
        if (vertex instanceof Join || vertex instanceof JoinDef) {
            String type = (String)((GraphableVertex)vertex).getBuiltInProperty(BuiltInVertexProperties.TYPE);
            if (StringUtils.isNotBlank((CharSequence)type) && type.equals("Route")) {
                return ROUTE_LABEL;
            }
            return JOIN_LABEL;
        }
        return XXX_LABEL;
    }
}

