/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainPath
extends Path {
    private static final Logger log = LoggerFactory.getLogger(DomainPath.class);
    private ItemPath target = null;

    public DomainPath() {
    }

    public DomainPath(String[] path) {
        super(path);
    }

    public DomainPath(String path) {
        super(path);
    }

    public DomainPath(String path, ItemPath entity) {
        super(path);
        this.setItemPath(entity);
    }

    public DomainPath(DomainPath parent, String child) {
        super(parent, child);
    }

    @Override
    public String getRoot() {
        return "domain";
    }

    public DomainPath getParent() {
        if (this.mPath.length == 0) {
            return null;
        }
        String[] parentPath = new String[this.mPath.length - 1];
        System.arraycopy(this.mPath, 0, parentPath, 0, parentPath.length);
        return new DomainPath(parentPath);
    }

    public void setItemPath(ItemPath newTarget) {
        this.target = newTarget;
    }

    public ItemPath getTarget() {
        return this.target;
    }

    @Override
    public ItemPath getItemPath() throws ObjectNotFoundException {
        if (this.target == null) {
            try {
                this.setItemPath(Gateway.getLookup().resolvePath(this));
                if (this.target == null) {
                    throw new ObjectNotFoundException("Path " + this.toString() + " does not resolve to an Item");
                }
            }
            catch (InvalidItemPathException e) {
                throw new ObjectNotFoundException(e.getMessage());
            }
        }
        return this.target;
    }

    public String getTargetUUID() {
        if (this.target != null) {
            return this.target.getUUID().toString();
        }
        return null;
    }

    public void setTargetUUID(String uuid) {
        if (uuid == null) {
            this.target = null;
        } else {
            try {
                this.target = new ItemPath(uuid);
            }
            catch (InvalidItemPathException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public boolean isContext() {
        return this.target == null;
    }

    @Override
    public String getName() {
        if (this.mPath.length > 0) {
            return this.mPath[this.mPath.length - 1];
        }
        return this.getRoot();
    }

    @Override
    public String getClusterPath() {
        return StringUtils.remove((String)((Object)((Object)ClusterType.PATH) + "/Domain/" + StringUtils.join((Object[])this.mPath, (String)"")), (String)".");
    }
}

